/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.image.BufferedImage;

public class TripleThread
extends Thread {
    private TripleJDialog tripleJDialog;
    private int W_W;
    private int W_H;
    private int SCW;
    private int SCH;
    private BufferedImage tmpImage;
    private int i;
    private int ii;
    private int[][] pixels;
    private int j;
    private int jMin;
    private int jMaxDefault;
    private int jMax;
    private int k;
    private int kMin;
    private int kMaxDefault;
    private int kMax;
    private int l;
    private int n;
    private int minus;
    private Color color;

    public TripleThread(TripleJDialog tripleJDialog) {
        this.tripleJDialog = tripleJDialog;
        this.W_W = tripleJDialog.W_W;
        this.W_H = tripleJDialog.W_H;
        this.SCW = tripleJDialog.SCW;
        this.SCH = tripleJDialog.SCH;
        this.tmpImage = tripleJDialog.tmpImage;
        this.i = tripleJDialog.i;
        this.ii = tripleJDialog.ii;
        this.pixels = tripleJDialog.pixels;
        this.jMin = tripleJDialog.jMin;
        this.jMaxDefault = tripleJDialog.jMaxDefault;
        this.jMax = tripleJDialog.jMax;
        this.kMin = tripleJDialog.kMin;
        this.kMaxDefault = tripleJDialog.kMaxDefault;
        this.kMax = tripleJDialog.kMax;
        this.n = tripleJDialog.n;
        this.minus = tripleJDialog.minus;
    }

    @Override
    public void run() {
        this.startRendering();
        if (this.tripleJDialog.tripleThread != null) {
            this.tripleJDialog.complete();
        }
    }

    protected void startRendering() {
        double OD = 0.0;
        double ED = (double)this.W_W / 2.0 * 10.0;
        int[][][] gx = new int[2][this.jMaxDefault][this.kMaxDefault];
        int[][][] gy = new int[2][this.jMaxDefault][this.kMaxDefault];
        int lMin = this.n - 1;
        int lMax = 0;
        int lRange = 0;
        int x = 0;
        int y = 0;
        int z = 0;
        double xx = 0.0;
        double yy = 0.0;
        this.j = 0;
        while (this.j < this.jMaxDefault && this.tripleJDialog.tripleThread != null) {
            this.k = 0;
            while (this.k < this.kMaxDefault && this.tripleJDialog.tripleThread != null) {
                this.l = this.pixels[this.j][this.k];
                lMin = Math.min(lMin, this.l);
                lMax = Math.max(lMax, this.l);
                ++this.k;
            }
            ++this.j;
        }
        lRange = lMax - lMin + 1;
        this.j = 0;
        while (this.j < this.jMaxDefault && this.tripleJDialog.tripleThread != null) {
            this.k = 0;
            while (this.k < this.kMaxDefault && this.tripleJDialog.tripleThread != null) {
                this.l = this.pixels[this.j][this.k];
                this.l = this.minus * ((this.l - lMin) * (this.W_W / 3) / lRange);
                for (int m = 0; m < 2; ++m) {
                    x = this.j * this.i - this.W_W / 2;
                    y = m == 0 ? 0 : -this.l;
                    z = -(this.k * this.i - this.W_H / 2);
                    Triple triple = new Triple(x, y, z);
                    triple.rollY(0.0, 0.0, 0.0, -30.0);
                    triple.rollX(0.0, 0.0, 0.0, -30.0);
                    triple.scale(0.0, 0.0, 0.0, 0.75);
                    triple.move(0.0, 0.0, triple.getZ() + OD + ED);
                    xx = triple.getScreenX(ED);
                    yy = triple.getScreenY(ED);
                    gx[m][this.j][this.k] = (int)xx + this.W_W / 2;
                    gy[m][this.j][this.k] = (int)yy + this.W_W / 2;
                }
                ++this.k;
            }
            ++this.j;
        }
        this.j = this.jMin;
        while (this.j < this.jMax && this.tripleJDialog.tripleThread != null) {
            this.k = this.kMin;
            while (this.k < this.kMax && this.tripleJDialog.tripleThread != null) {
                this.color = new Color(this.tmpImage.getRGB(this.SCW + this.j * this.i, this.SCH + this.k * this.i));
                if (this.tripleJDialog.renderingJToggleButton[0].isSelected()) {
                    Utils.drawFillRect(this.tripleJDialog.offg, null, gx[0][this.j][this.k], gy[0][this.j][this.k], this.ii, this.ii, this.color);
                }
                if (this.tripleJDialog.renderingJToggleButton[1].isSelected()) {
                    Utils.drawFillRect(this.tripleJDialog.offg, null, gx[1][this.j][this.k], gy[1][this.j][this.k], this.ii, this.ii, this.color);
                }
                if (this.tripleJDialog.renderingJToggleButton[2].isSelected()) {
                    if (this.j + 1 < this.jMax) {
                        Utils.drawDrawLine(this.tripleJDialog.offg, null, gx[1][this.j][this.k], gy[1][this.j][this.k], gx[1][this.j + 1][this.k], gy[1][this.j + 1][this.k], this.color);
                    }
                    if (this.k + 1 < this.kMax) {
                        Utils.drawDrawLine(this.tripleJDialog.offg, null, gx[1][this.j][this.k], gy[1][this.j][this.k], gx[1][this.j][this.k + 1], gy[1][this.j][this.k + 1], this.color);
                    }
                }
                ++this.k;
            }
            this.tripleJDialog.tripleJPanel.repaint();
            ++this.j;
        }
    }
}

