/*
 * Decompiled with CFR 0.152.
 */
public class Triple {
    private double x;
    private double y;
    private double z;

    public Triple() {
    }

    public Triple(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Triple(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Triple(Triple triple) {
        this.x = triple.x;
        this.y = triple.y;
        this.z = triple.z;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public String toString() {
        return String.valueOf(this.x) + String.valueOf(this.y) + String.valueOf(this.z);
    }

    public void move(double l, double m, double n) {
        this.x += l;
        this.y += m;
        this.z += n;
    }

    public void pitch(double degree) {
        double xx = this.x;
        double yy = this.y;
        double zz = this.z;
        degree = Math.PI * degree / 180.0;
        this.x = xx;
        this.y = yy * Math.cos(degree) + zz * Math.sin(degree);
        this.z = -yy * Math.sin(degree) + zz * Math.cos(degree);
    }

    public void heading(double degree) {
        double xx = this.x;
        double yy = this.y;
        double zz = this.z;
        degree = Math.PI * degree / 180.0;
        this.x = xx * Math.cos(degree) - zz * Math.sin(degree);
        this.y = yy;
        this.z = xx * Math.sin(degree) + zz * Math.cos(degree);
    }

    public void bank(double degree) {
        double xx = this.x;
        double yy = this.y;
        double zz = this.z;
        degree = Math.PI * degree / 180.0;
        this.x = xx * Math.cos(degree) + yy * Math.sin(degree);
        this.y = -xx * Math.sin(degree) + yy * Math.cos(degree);
        this.z = zz;
    }

    public void rollXYZ(double xa, double ya, double za, double dx, double dy, double dz) {
        double xx = this.x;
        double yy = this.y;
        double zz = this.z;
        dx = Math.PI * dx / 180.0;
        dy = Math.PI * dy / 180.0;
        dz = Math.PI * dz / 180.0;
        this.x = (xx - xa) * (Math.cos(dy) * Math.cos(dz) + Math.sin(dx) * Math.sin(dy) * Math.sin(dz)) + (yy - ya) * Math.cos(dx) * Math.sin(dz) + (zz - za) * (-Math.sin(dy) * Math.cos(dz) + Math.sin(dx) * Math.cos(dy) * Math.sin(dz)) + xa;
        this.y = (xx - xa) * (-Math.cos(dy) * Math.sin(dz) + Math.sin(dx) * Math.sin(dy) * Math.cos(dz)) + (yy - ya) * Math.cos(dx) * Math.cos(dz) + (zz - za) * (Math.sin(dy) * Math.sin(dz) + Math.sin(dx) * Math.cos(dy) * Math.cos(dz)) + ya;
        this.z = (xx - xa) * Math.cos(dx) * Math.sin(dy) - (yy - ya) * Math.sin(dx) + (zz - za) * Math.cos(dx) * Math.cos(dy) + za;
    }

    public void rollX(double xa, double ya, double za, double dx) {
        double xx = this.x;
        double yy = this.y;
        double zz = this.z;
        dx = Math.PI * dx / 180.0;
        double dy = 0.0;
        double dz = 0.0;
        this.x = (xx - xa) * (Math.cos(dy) * Math.cos(dz) + Math.sin(dx) * Math.sin(dy) * Math.sin(dz)) + (yy - ya) * Math.cos(dx) * Math.sin(dz) + (zz - za) * (-Math.sin(dy) * Math.cos(dz) + Math.sin(dx) * Math.cos(dy) * Math.sin(dz)) + xa;
        this.y = (xx - xa) * (-Math.cos(dy) * Math.sin(dz) + Math.sin(dx) * Math.sin(dy) * Math.cos(dz)) + (yy - ya) * Math.cos(dx) * Math.cos(dz) + (zz - za) * (Math.sin(dy) * Math.sin(dz) + Math.sin(dx) * Math.cos(dy) * Math.cos(dz)) + ya;
        this.z = (xx - xa) * Math.cos(dx) * Math.sin(dy) - (yy - ya) * Math.sin(dx) + (zz - za) * Math.cos(dx) * Math.cos(dy) + za;
    }

    public void rollY(double xa, double ya, double za, double dy) {
        double xx = this.x;
        double yy = this.y;
        double zz = this.z;
        double dx = 0.0;
        dy = Math.PI * dy / 180.0;
        double dz = 0.0;
        this.x = (xx - xa) * (Math.cos(dy) * Math.cos(dz) + Math.sin(dx) * Math.sin(dy) * Math.sin(dz)) + (yy - ya) * Math.cos(dx) * Math.sin(dz) + (zz - za) * (-Math.sin(dy) * Math.cos(dz) + Math.sin(dx) * Math.cos(dy) * Math.sin(dz)) + xa;
        this.y = (xx - xa) * (-Math.cos(dy) * Math.sin(dz) + Math.sin(dx) * Math.sin(dy) * Math.cos(dz)) + (yy - ya) * Math.cos(dx) * Math.cos(dz) + (zz - za) * (Math.sin(dy) * Math.sin(dz) + Math.sin(dx) * Math.cos(dy) * Math.cos(dz)) + ya;
        this.z = (xx - xa) * Math.cos(dx) * Math.sin(dy) - (yy - ya) * Math.sin(dx) + (zz - za) * Math.cos(dx) * Math.cos(dy) + za;
    }

    public void rollZ(double xa, double ya, double za, double dz) {
        double xx = this.x;
        double yy = this.y;
        double zz = this.z;
        double dx = 0.0;
        double dy = 0.0;
        dz = Math.PI * dz / 180.0;
        this.x = (xx - xa) * (Math.cos(dy) * Math.cos(dz) + Math.sin(dx) * Math.sin(dy) * Math.sin(dz)) + (yy - ya) * Math.cos(dx) * Math.sin(dz) + (zz - za) * (-Math.sin(dy) * Math.cos(dz) + Math.sin(dx) * Math.cos(dy) * Math.sin(dz)) + xa;
        this.y = (xx - xa) * (-Math.cos(dy) * Math.sin(dz) + Math.sin(dx) * Math.sin(dy) * Math.cos(dz)) + (yy - ya) * Math.cos(dx) * Math.cos(dz) + (zz - za) * (Math.sin(dy) * Math.sin(dz) + Math.sin(dx) * Math.cos(dy) * Math.cos(dz)) + ya;
        this.z = (xx - xa) * Math.cos(dx) * Math.sin(dy) - (yy - ya) * Math.sin(dx) + (zz - za) * Math.cos(dx) * Math.cos(dy) + za;
    }

    public void roll(double xa, double ya, double za, double a, double b, double c, double d) {
        double xx = this.x;
        double yy = this.y;
        double zz = this.z;
        double n1 = Math.cos(a);
        double n2 = Math.cos(b);
        double n3 = Math.cos(c);
        double p = 1.0 - Math.cos(d);
        this.x = (xx - xa) * (p * n1 * n1 + Math.cos(d)) + (yy - ya) * (p * n1 * n2 - n3 * Math.sin(d)) + (zz - za) * (p * n1 * n3 + n2 * Math.sin(d)) + xa;
        this.y = (xx - xa) * (p * n1 * n2 + n3 * Math.sin(d)) + (yy - ya) * (p * n2 * n2 - Math.cos(d)) + (zz - za) * (p * n2 * n3 - n1 * Math.sin(d)) + ya;
        this.z = (xx - xa) * (p * n1 * n3 - n2 * Math.sin(d)) + (yy - ya) * (p * n2 * n3 - n1 * Math.sin(d)) + (zz - za) * (p * n3 * n3 + Math.cos(d)) + za;
    }

    public void scale(double xa, double ya, double za, double scale) {
        double xx = this.x;
        double yy = this.y;
        double zz = this.z;
        this.x = scale * (xx - xa) + xa;
        this.y = scale * (yy - ya) + ya;
        this.z = scale * (zz - za) + za;
    }

    public double getScreenX(double distance) {
        double xx = distance * this.getX() / this.getZ();
        return xx;
    }

    public double getScreenY(double distance) {
        double yy = distance * this.getY() / this.getZ();
        return yy;
    }
}

