/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class TileAutomataJDialog
extends JDialog
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    public MainJFrame mainJFrame;
    protected Color BGC = Utils.P2C;
    protected int F_W;
    protected int F_H;
    protected int W_W;
    protected int W_H;
    protected int SCW;
    protected int SCH;
    protected int width;
    protected int height;
    protected Graphics g;
    protected Graphics offg;
    protected Image offImage;
    protected BufferedImage tmpImage;
    private int programOption;
    private int programFormula4Option;
    private int programFormula5Option;
    protected int renderingQualityOption;
    protected ColorTable ct;
    protected int colorAssignmentOption;
    protected int csp;
    protected int cs;
    protected int ctq;
    protected int[][] pixels;
    protected int i;
    protected int ii;
    protected int j;
    protected int jMinDefault;
    protected int jMin;
    protected int jMaxDefault;
    protected int jMax;
    protected int k;
    protected int kMinDefault;
    protected int kMin;
    protected int kMaxDefault;
    protected int kMax;
    protected int l;
    protected int n;
    protected int nMinus1;
    protected int one;
    protected int minus;
    private JToolBar jtoolbar = new JToolBar();
    protected JButton saveJButton = new JButton();
    protected JButton printJButton = new JButton();
    protected JButton copyJButton = new JButton();
    private JButton startJButton = new JButton();
    private JButton suspendJButton = new JButton();
    private JButton resumeJButton = new JButton();
    private JButton stopJButton = new JButton();
    protected JButton colorJButton = new JButton();
    protected JCheckBox frameJCheckBox = new JCheckBox();
    private BufferedImage colorImage;
    private Graphics colorg;
    private ImageIcon colorImageIcon;
    private JButton undoJButton = new JButton();
    protected JToggleButton fixJToggleButton;
    private JButton redoJButton = new JButton();
    protected boolean[] calculationFlag = new boolean[]{true, true, true, true, true, true, true, true, true};
    protected String[] calculationString = new String[]{"\u524d\u306e\u884c\u306e\u5de6\u96a3\u306e\u5217\u306e\u5024\u3092\u52a0\u7b97\u3057\u307e\u3059\u3002", "\u524d\u306e\u884c\u306e\u540c\u3058\u5217\u306e\u5024\u3092\u52a0\u7b97\u3057\u307e\u3059\u3002", "\u524d\u306e\u884c\u306e\u53f3\u96a3\u306e\u5217\u306e\u5024\u3092\u52a0\u7b97\u3057\u307e\u3059\u3002", "\u540c\u3058\u884c\u306e\u5de6\u96a3\u306e\u5217\u306e\u5024\u3092\u52a0\u7b97\u3057\u307e\u3059\u3002", "\u540c\u3058\u884c\u306e\u540c\u3058\u5217\u306e\u5024\u3092\u52a0\u7b97\u3057\u307e\u3059\u3002", "\u540c\u3058\u884c\u306e\u53f3\u96a3\u306e\u5217\u306e\u5024\u3092\u52a0\u7b97\u3057\u307e\u3059\u3002", "\u5f8c\u306e\u884c\u306e\u5de6\u96a3\u306e\u5217\u306e\u5024\u3092\u52a0\u7b97\u3057\u307e\u3059\u3002", "\u5f8c\u306e\u884c\u306e\u540c\u3058\u5217\u306e\u5024\u3092\u52a0\u7b97\u3057\u307e\u3059\u3002", "\u5f8c\u306e\u884c\u306e\u53f3\u96a3\u306e\u5217\u306e\u5024\u3092\u52a0\u7b97\u3057\u307e\u3059\u3002"};
    protected JPanel calculationJPanel = new JPanel();
    protected JCheckBox[] calculationJCheckBox = new JCheckBox[this.calculationString.length];
    private JScrollPane jscrollpane = new JScrollPane();
    private JPanel jpanel = new JPanel();
    protected JTextField jtextfield = new JTextField("\u521d\u671f\u5024 : 8888 \u884c\u76ee, \u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u914d\u5217 : 8888 \u5217 8888 \u884c\u76ee\u304b\u3089 8888 \u5217 8888 \u884c\u76ee\u307e\u3067");
    private JButton exitJButton = new JButton("\u7d42\u4e86");
    protected TileAutomataThread tileAutomataThread;
    protected String titleString = "JFractal - \u683c\u5b50\u30fb\u30aa\u30fc\u30c8\u30de\u30c8\u30f3";
    JPanel tileAutomataJPanel = new JPanel(){
        private static final long serialVersionUID = 1L;

        @Override
        public void paintComponent(Graphics gg) {
            super.paintComponent(gg);
            TileAutomataJDialog.this.g = this.getGraphics();
            if (TileAutomataJDialog.this.offImage != null) {
                gg.drawImage(TileAutomataJDialog.this.offImage, (int)((this.getSize().getWidth() - (double)TileAutomataJDialog.this.W_H) / 2.0), (int)((this.getSize().getHeight() - (double)TileAutomataJDialog.this.W_H) / 2.0 + (double)(TileAutomataJDialog.this.SCH / 4)), this);
            }
        }
    };
    protected boolean breakFlag;
    protected JToggleButton progressJToggleButton;
    protected Object sourceObject;
    protected String commandString;

    public TileAutomataJDialog(MainJFrame mainJFrame) {
        this.mainJFrame = mainJFrame;
        this.init();
        this.createTileAutomataJDialog();
        this.prepare();
    }

    protected void init() {
        this.F_W = this.mainJFrame.F_W;
        this.F_H = this.mainJFrame.F_H;
        this.W_W = this.mainJFrame.W_W;
        this.W_H = this.mainJFrame.W_H;
        this.SCW = this.mainJFrame.SCW;
        this.SCH = this.mainJFrame.SCH;
        this.tmpImage = this.mainJFrame.tmpImage;
        this.renderingQualityOption = this.mainJFrame.renderingQualityOption;
        this.i = Utils.getI(this.renderingQualityOption);
        this.ii = Utils.getII(this.renderingQualityOption);
        this.width = this.W_H + 1 * this.i;
        this.height = this.W_H + 1 * this.i;
        this.ct = this.mainJFrame.ct;
        this.colorAssignmentOption = this.mainJFrame.colorAssignmentOption;
        this.csp = this.mainJFrame.csp;
        this.cs = this.mainJFrame.cs;
        this.ctq = this.ct.colorTable.length;
        this.programOption = this.mainJFrame.programOption;
        this.programFormula4Option = this.mainJFrame.programFormula4Option;
        this.programFormula5Option = this.mainJFrame.programFormula5Option;
        this.n = this.mainJFrame.n;
        if (this.programOption != 18 || this.programFormula4Option != 3 || this.programFormula5Option == 1) {
            // empty if block
        }
        if (this.programOption == 18 && this.programFormula4Option == 3 && this.programFormula5Option == 2) {
            this.n = this.W_W / 2 + 1;
        } else if (this.programOption == 18 && this.programFormula4Option == 3 && this.programFormula5Option == 3) {
            this.n = this.W_H / 2 + 1;
        }
        if (this.colorAssignmentOption != 4) {
            if (this.colorAssignmentOption == 0 || this.colorAssignmentOption == 2) {
                this.nMinus1 = this.n - 1;
                this.one = 0;
                this.minus = 1;
            } else if (this.colorAssignmentOption == 1 || this.colorAssignmentOption == 3) {
                this.nMinus1 = this.n - 1;
                this.one = 1;
                this.minus = -1;
            }
        } else if (this.csp > 0) {
            this.nMinus1 = 0;
            this.one = 0;
            this.minus = 1;
        } else {
            this.nMinus1 = this.n - 1;
            this.one = 1;
            this.minus = 1;
        }
        this.pixels = this.mainJFrame.pixels;
        this.jMin = this.jMinDefault = 0;
        this.jMax = this.jMaxDefault = this.pixels.length;
        this.kMin = this.kMinDefault = 0;
        this.kMax = this.kMaxDefault = this.pixels[0].length;
    }

    protected void prepare() {
        this.g = this.tileAutomataJPanel.getGraphics();
        this.offImage = this.tileAutomataJPanel.createImage(this.width, this.height);
        this.offg = this.offImage.getGraphics();
        Utils.drawFillRect(this.g, this.offg, 0, 0, this.width, this.height, this.BGC);
        this.tileAutomataJPanel.setPreferredSize(new Dimension((this.SCW + this.width + this.SCW) / 2, (this.SCH + this.height + this.SCH + this.SCH / 2) / 2));
        this.tileAutomataJPanel.updateUI();
        this.pack();
        this.tileAutomataJPanel.setPreferredSize(new Dimension(this.SCW + this.width + this.SCW, this.SCH + this.height + this.SCH + this.SCH / 2));
        this.tileAutomataJPanel.updateUI();
        this.jtextfield.selectAll();
        this.saveJButton.setEnabled(false);
        this.printJButton.setEnabled(false);
        this.copyJButton.setEnabled(false);
        this.startJButton.setVisible(true);
        this.suspendJButton.setVisible(false);
        this.resumeJButton.setVisible(false);
        this.stopJButton.setEnabled(false);
        this.undoJButton.setEnabled(false);
        this.redoJButton.setEnabled(false);
        this.jtextfield.selectAll();
        this.jtextfield.replaceSelection("\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u914d\u5217 : 8888 \u5217 8888 \u884c\u76ee\u304b\u3089 8888 \u5217 8888 \u884c\u76ee\u307e\u3067, \u53cd\u5fa9\u8a08\u7b97 : 8888 \u56de\u76ee");
        this.pack();
        this.jtextfield.selectAll();
        this.jtextfield.replaceSelection("");
    }

    protected void createTileAutomataJDialog() {
        this.jtoolbar.setLayout(new FlowLayout(1, 4, 2));
        this.jtoolbar.setFloatable(false);
        this.saveJButton.setIcon(this.mainJFrame.saveImageIcon);
        this.saveJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.saveJButton);
        this.saveJButton.addActionListener(this);
        this.saveJButton.setToolTipText("\u3053\u306e\u63cf\u753b\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u3057\u307e\u3059\u3002");
        this.saveJButton.setEnabled(false);
        this.printJButton.setIcon(this.mainJFrame.printImageIcon);
        this.printJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.printJButton);
        this.printJButton.addActionListener(this);
        this.printJButton.setToolTipText("\u3053\u306e\u63cf\u753b\u3092\u5370\u5237\u3057\u307e\u3059\u3002");
        this.printJButton.setEnabled(false);
        this.copyJButton.setIcon(this.mainJFrame.copyImageIcon);
        this.copyJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.copyJButton);
        this.copyJButton.addActionListener(this);
        this.copyJButton.setToolTipText("\u3053\u306e\u63cf\u753b\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002");
        this.copyJButton.setEnabled(false);
        this.jtoolbar.addSeparator(new Dimension(8, 8));
        this.startJButton.setIcon(this.mainJFrame.startImageIcon0);
        this.startJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.startJButton);
        this.startJButton.addActionListener(this);
        this.startJButton.setToolTipText("\u683c\u5b50\u30fb\u30aa\u30fc\u30c8\u30de\u30c8\u30f3\u306e\u63cf\u753b\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        this.suspendJButton.setIcon(this.mainJFrame.suspendImageIcon0);
        this.suspendJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.suspendJButton);
        this.suspendJButton.addActionListener(this);
        this.suspendJButton.setToolTipText("\u683c\u5b50\u30fb\u30aa\u30fc\u30c8\u30de\u30c8\u30f3\u306e\u63cf\u753b\u3092\u4e00\u6642\u505c\u6b62\u3057\u307e\u3059\u3002");
        this.resumeJButton.setIcon(this.mainJFrame.resumeImageIcon0);
        this.resumeJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.resumeJButton);
        this.resumeJButton.addActionListener(this);
        this.resumeJButton.setToolTipText("\u683c\u5b50\u30fb\u30aa\u30fc\u30c8\u30de\u30c8\u30f3\u306e\u63cf\u753b\u3092\u518d\u958b\u3057\u307e\u3059\u3002");
        this.stopJButton.setIcon(this.mainJFrame.stopImageIcon0);
        this.stopJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.stopJButton);
        this.stopJButton.addActionListener(this);
        this.stopJButton.setToolTipText("\u683c\u5b50\u30fb\u30aa\u30fc\u30c8\u30de\u30c8\u30f3\u306e\u63cf\u753b\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
        this.stopJButton.setEnabled(false);
        this.jtoolbar.addSeparator(new Dimension(8, 8));
        this.colorImage = new BufferedImage(this.mainJFrame.saveImageIcon.getIconWidth(), this.mainJFrame.saveImageIcon.getIconHeight(), 5);
        this.colorg = this.colorImage.getGraphics();
        Utils.drawFillRect(this.colorg, null, 0, 0, this.colorImage.getWidth(), this.colorImage.getHeight(), this.BGC);
        this.colorImageIcon = new ImageIcon(this.colorImage);
        this.colorJButton.setIcon(this.colorImageIcon);
        this.colorJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.colorJButton);
        this.colorJButton.addActionListener(this);
        this.colorJButton.setToolTipText("\u80cc\u666f\u8272\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        this.frameJCheckBox = new JCheckBox("\u67a0", true);
        this.jtoolbar.add(this.frameJCheckBox);
        this.frameJCheckBox.setToolTipText("\u30c1\u30a7\u30c3\u30af\u3092\u5165\u308c\u308b\u3068\u67a0\u3092\u63cf\u753b\u3057\u307e\u3059\u3002");
        this.undoJButton.setIcon(this.mainJFrame.undoDataImageIcon);
        this.undoJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.undoJButton);
        this.undoJButton.addActionListener(this);
        this.undoJButton.setToolTipText("\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u5024\u3092\u53d6\u5f97\u3059\u308b\u958b\u59cb\u70b9\u3092\u4e00\u3064\u623b\u3057\u307e\u3059\u3002");
        this.undoJButton.setEnabled(false);
        this.fixJToggleButton = new JToggleButton(this.mainJFrame.fixImageIcon, false);
        this.fixJToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.fixJToggleButton);
        this.fixJToggleButton.setToolTipText("\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u5024\u3092\u53d6\u5f97\u3059\u308b\u958b\u59cb\u70b9\u3092\u56fa\u5b9a\u3057\u307e\u3059\u3002");
        this.redoJButton.setIcon(this.mainJFrame.redoDataImageIcon);
        this.redoJButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.redoJButton);
        this.redoJButton.addActionListener(this);
        this.redoJButton.setToolTipText("\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u5024\u3092\u53d6\u5f97\u3059\u308b\u958b\u59cb\u70b9\u3092\u4e00\u3064\u9032\u3081\u307e\u3059\u3002");
        this.redoJButton.setEnabled(false);
        this.jtoolbar.addSeparator(new Dimension(8, 8));
        this.calculationJPanel.setLayout(new GridLayout(3, 3, 0, 0));
        for (int i = 0; i < this.calculationString.length; ++i) {
            this.calculationJCheckBox[i] = new JCheckBox();
            this.calculationJCheckBox[i].setSelected(this.calculationFlag[i]);
            this.calculationJPanel.add(this.calculationJCheckBox[i]);
            this.calculationJCheckBox[i].setToolTipText(this.calculationString[i]);
        }
        this.jtoolbar.add(this.calculationJPanel);
        this.jtoolbar.addSeparator(new Dimension(8, 8));
        this.progressJToggleButton = new JToggleButton(this.mainJFrame.tileAutomataImageIcon, true);
        this.progressJToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.jtoolbar.add(this.progressJToggleButton);
        this.progressJToggleButton.setToolTipText("\u9014\u4e2d\u7d4c\u904e\u3092\u63cf\u753b\u3057\u307e\u3059\u3002");
        this.jtextfield.setBorder(new TitledBorder(new EtchedBorder(), "\u4f4d\u7f6e", 1, 2));
        this.jtextfield.setEditable(false);
        this.jtextfield.setHorizontalAlignment(0);
        this.exitJButton.addActionListener(this);
        this.jpanel.setLayout(new BorderLayout(8, 8));
        this.jpanel.add((Component)this.jtextfield, "North");
        this.jpanel.add((Component)this.tileAutomataJPanel, "Center");
        this.jpanel.add((Component)this.exitJButton, "South");
        this.tileAutomataJPanel.setBorder(new TitledBorder(new EtchedBorder(), "\u753b\u50cf", 1, 2));
        this.jscrollpane.getViewport().add(this.jpanel);
        this.getContentPane().setLayout(new BorderLayout(8, 8));
        this.getContentPane().add((Component)this.jtoolbar, "North");
        this.getContentPane().add((Component)this.jscrollpane, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.setTitle(this.titleString);
        this.setModal(false);
        this.setVisible(true);
    }

    protected void complete() {
        if (this.tileAutomataThread != null) {
            this.tileAutomataThread = null;
        }
        this.startJButton.setEnabled(true);
        this.stopJButton.setEnabled(false);
        this.colorJButton.setEnabled(true);
        this.frameJCheckBox.setEnabled(true);
        this.saveJButton.setEnabled(true);
        this.printJButton.setEnabled(true);
        this.copyJButton.setEnabled(true);
        this.undoJButton.setEnabled(false);
        this.redoJButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.sourceObject = ae.getSource();
        this.commandString = ae.getActionCommand();
        if (this.sourceObject == this.saveJButton || this.sourceObject == this.printJButton || this.sourceObject == this.copyJButton) {
            this.mainJFrame.actionPerformed(ae);
        } else if (this.sourceObject == this.startJButton) {
            this.jMin = this.jMinDefault;
            this.kMin = this.kMinDefault;
            this.mainJFrame.pictureJPanel.repaint();
            this.prepare();
            if (this.tileAutomataThread == null) {
                this.tileAutomataThread = new TileAutomataThread(this);
            }
            this.tileAutomataThread.start();
            this.saveJButton.setEnabled(false);
            this.printJButton.setEnabled(false);
            this.copyJButton.setEnabled(false);
            this.startJButton.setVisible(false);
            this.suspendJButton.setVisible(true);
            this.stopJButton.setEnabled(true);
            this.colorJButton.setEnabled(false);
            this.frameJCheckBox.setEnabled(false);
            this.undoJButton.setEnabled(true);
            this.redoJButton.setEnabled(true);
        } else if (this.sourceObject == this.suspendJButton) {
            this.j = this.tileAutomataThread.j;
            this.k = this.tileAutomataThread.k;
            if (this.tileAutomataThread != null) {
                this.tileAutomataThread = null;
            }
            this.printJButton.setEnabled(true);
            this.copyJButton.setEnabled(true);
            this.suspendJButton.setVisible(false);
            this.resumeJButton.setVisible(true);
            this.stopJButton.setEnabled(true);
            this.colorJButton.setEnabled(true);
            this.frameJCheckBox.setEnabled(true);
            this.undoJButton.setEnabled(false);
            this.redoJButton.setEnabled(false);
            this.saveJButton.setEnabled(true);
        } else if (this.sourceObject == this.resumeJButton) {
            this.jMin = this.j;
            this.kMin = this.k;
            if (this.tileAutomataThread == null) {
                this.tileAutomataThread = new TileAutomataThread(this);
            }
            this.tileAutomataThread.start();
            this.saveJButton.setEnabled(false);
            this.printJButton.setEnabled(false);
            this.copyJButton.setEnabled(false);
            this.suspendJButton.setVisible(true);
            this.resumeJButton.setVisible(false);
            this.stopJButton.setEnabled(true);
            this.colorJButton.setEnabled(false);
            this.frameJCheckBox.setEnabled(false);
            this.undoJButton.setEnabled(true);
            this.redoJButton.setEnabled(true);
        } else if (this.sourceObject == this.stopJButton) {
            if (this.tileAutomataThread != null) {
                this.tileAutomataThread = null;
            }
            this.saveJButton.setEnabled(true);
            this.printJButton.setEnabled(true);
            this.copyJButton.setEnabled(true);
            this.startJButton.setVisible(true);
            this.suspendJButton.setVisible(false);
            this.resumeJButton.setVisible(false);
            this.stopJButton.setEnabled(false);
            this.colorJButton.setEnabled(true);
            this.frameJCheckBox.setEnabled(true);
            this.undoJButton.setEnabled(false);
            this.redoJButton.setEnabled(false);
        } else if (this.sourceObject == this.colorJButton) {
            Color color = JColorChooser.showDialog(this, "JFractal - \u30ab\u30e9\u30fc\u30c1\u30e5\u30fc\u30b6\u30fc", this.BGC);
            if (color != null) {
                this.BGC = color;
                Utils.drawFillRect(this.colorg, null, 0, 0, this.colorImage.getWidth(), this.colorImage.getHeight(), this.BGC);
                Utils.drawFillRect(this.g, this.offg, 0, 0, this.width, this.height, this.BGC);
                this.tileAutomataJPanel.repaint();
                this.saveJButton.setEnabled(false);
                this.printJButton.setEnabled(false);
                this.copyJButton.setEnabled(false);
            }
        } else if (this.sourceObject == this.undoJButton) {
            int jj = this.tileAutomataThread.j;
            int kk = this.tileAutomataThread.k;
            if (--kk < 0) {
                kk = this.W_H / this.i - 1;
                if (--jj < 0) {
                    jj = this.W_W / this.i - 1;
                }
            }
            this.j = jj;
            this.k = kk;
            this.breakFlag = true;
            this.mainJFrame.pictureJPanel.repaint();
        } else if (this.sourceObject == this.redoJButton) {
            int jj = this.tileAutomataThread.j;
            int kk = this.tileAutomataThread.k;
            if (++kk >= this.W_H / this.i) {
                kk = 0;
                if (++jj >= this.W_W / this.i) {
                    jj = 0;
                }
            }
            this.j = jj;
            this.k = kk;
            this.breakFlag = true;
            this.mainJFrame.pictureJPanel.repaint();
        } else if (this.sourceObject == this.exitJButton || this.sourceObject == this.mainJFrame.mainJMenuBar.toolTileAutomataExit) {
            this.mainJFrame.tileAutomataFlag = false;
            this.mainJFrame.menuSet(2);
            if (this.tileAutomataThread != null) {
                this.tileAutomataThread = null;
            }
            this.setVisible(false);
            this.mainJFrame.g.drawImage(this.tmpImage, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this);
            this.mainJFrame.offg.drawImage(this.tmpImage, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this);
            this.mainJFrame.mainThreadOption = 2;
            this.mainJFrame.statusJToolBar.drawStatus(839);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getComponent() == this) {
            this.mainJFrame.tileAutomataFlag = false;
            this.mainJFrame.menuSet(2);
            if (this.tileAutomataThread != null) {
                this.tileAutomataThread = null;
            }
            this.setVisible(false);
            this.mainJFrame.g.drawImage(this.tmpImage, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this);
            this.mainJFrame.offg.drawImage(this.tmpImage, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this);
            this.mainJFrame.mainThreadOption = 2;
            this.mainJFrame.statusJToolBar.drawStatus(839);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

