/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.Random;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class SoundThread
extends Thread {
    private SoundJDialog soundJDialog;
    private int option;
    private int soundDirectionOption;
    private int W_W;
    private int W_H;
    private int SCW;
    private int SCH;
    private BufferedImage tmpImage;
    private int programOption;
    private int programFormula4Option;
    private int programFormula5Option;
    private int csp;
    private int colorAssignmentOption;
    private int colorOrderOption;
    private int[][] pixels;
    private int i;
    private int j;
    private int[] jj;
    private int jMin;
    private int jMax;
    private int k;
    private int[] kk;
    private int kMin;
    private int kMax;
    private int n;
    private int cols;
    private int lineShift;
    private int one = 0;
    private int minus = -1;
    private Color[] color;
    private Color[] colorReverse;
    private Color color9;
    private Color colorReverse9;
    protected Synthesizer synthesizer;
    private Receiver synthesizerReceiver;
    private Receiver sequencerReceiver;
    private Transmitter synthesizerTransmitter;
    private int synthesizerTransmitters;
    private Transmitter sequencerTransmitter;
    protected Sequencer sequencer;
    private int tracks;
    private Track[] track;
    private TargetDataLine targetDataLine;
    private SourceDataLine sourceDataLine;
    private Date date;
    private long timeStart;
    private long timeNow;

    public SoundThread(SoundJDialog soundJDialog, int option) {
        this.soundJDialog = soundJDialog;
        this.option = option;
        if (option == 0) {
            this.W_W = soundJDialog.W_W;
            this.W_H = soundJDialog.W_H;
            this.SCW = soundJDialog.SCW;
            this.SCH = soundJDialog.SCH;
            this.programOption = soundJDialog.programOption;
            this.programFormula4Option = soundJDialog.programFormula4Option;
            this.programFormula5Option = soundJDialog.programFormula5Option;
            this.n = soundJDialog.n;
            if (this.programOption != 18 || this.programFormula4Option != 3 || this.programFormula5Option == 1) {
                // empty if block
            }
            if (this.programOption == 18 && this.programFormula4Option == 3 && this.programFormula5Option == 2) {
                this.n = this.W_W / 2 + 1;
            } else if (this.programOption == 18 && this.programFormula4Option == 3 && this.programFormula5Option == 3) {
                this.n = this.W_H / 2 + 1;
            }
            this.tmpImage = soundJDialog.tmpImage;
            this.i = soundJDialog.i;
            this.colorOrderOption = soundJDialog.colorOrderOption;
            this.colorAssignmentOption = soundJDialog.colorAssignmentOption;
            this.csp = soundJDialog.csp;
            if (this.colorAssignmentOption != 4) {
                if (this.colorAssignmentOption == 0 || this.colorAssignmentOption == 2) {
                    this.one = 0;
                    this.minus = -1;
                } else if (this.colorAssignmentOption == 1 || this.colorAssignmentOption == 3) {
                    this.one = 1;
                    this.minus = 1;
                }
            } else if (this.csp > 0) {
                this.one = 0;
                this.minus = -1;
            } else {
                this.one = 1;
                this.minus = -1;
            }
            this.cols = soundJDialog.cols;
            this.lineShift = soundJDialog.lineShift;
            this.color = new Color[this.cols];
            this.colorReverse = new Color[this.cols];
            this.pixels = soundJDialog.pixels;
            this.jMin = soundJDialog.jMin;
            this.jMax = soundJDialog.jMax;
            this.kMin = soundJDialog.kMin;
            this.kMax = soundJDialog.kMax;
            this.jj = new int[16];
            this.kk = new int[16];
            this.soundDirectionOption = soundJDialog.soundDirectionOption;
        }
    }

    @Override
    public void run() {
        if (this.option == 0) {
            this.startSound();
        } else if (this.option == 1) {
            this.startPlay();
        }
    }

    protected int getValue(int col, int row, int option) {
        int value = this.pixels[col][row];
        Random random = new Random(value + col + row);
        for (int count = 0; count <= option; ++count) {
            value = Math.abs(random.nextInt());
        }
        if (option != 0) {
            value %= this.n;
        }
        return value;
    }

    protected int getPitch(int pitch, int number, int option) {
        if (option == 0) {
            pitch = this.soundJDialog.pitches[pitch];
        } else if (option == 1 || option == 2) {
            this.soundJDialog.pitchesJButton[this.soundJDialog.pitch_old[number]].setForeground(Utils.A1C);
            this.soundJDialog.pitchesJButton[this.soundJDialog.pitch_old[number]].setBackground(Utils.P3C);
            this.soundJDialog.pitchesJTextField[this.soundJDialog.pitch_old[number]].setForeground(Utils.A1C);
            this.soundJDialog.pitchesJTextField[this.soundJDialog.pitch_old[number]].setBackground(Utils.A2C);
            this.soundJDialog.pitchesJTextField[this.soundJDialog.pitch_old[number]].setText(Integer.toString(this.soundJDialog.pitches[this.soundJDialog.pitch_old[number]]));
            this.soundJDialog.pitch_old[number] = pitch;
            pitch = this.soundJDialog.pitches[pitch];
            this.soundJDialog.pitchesJButton[this.soundJDialog.pitch_old[number]].setForeground(Utils.A1C);
            this.soundJDialog.pitchesJButton[this.soundJDialog.pitch_old[number]].setBackground(Utils.P2C);
            this.soundJDialog.pitchesJTextField[this.soundJDialog.pitch_old[number]].setForeground(this.colorReverse[number]);
            this.soundJDialog.pitchesJTextField[this.soundJDialog.pitch_old[number]].setBackground(this.color[number]);
            if (option == 1) {
                this.soundJDialog.pitchesJTextField[this.soundJDialog.pitch_old[number]].setText(Utils.soundPitchString[pitch % 12] + pitch / 12);
            } else if (option == 2) {
                this.soundJDialog.pitchesJTextField[this.soundJDialog.pitch_old[number]].setText("\u4f11");
            }
        }
        return pitch;
    }

    protected int getVolumeHigh(int volume) {
        return volume;
    }

    protected int getVolumeLow(int volumePercussion) {
        return volumePercussion;
    }

    protected int getVelocity(int velocity) {
        return velocity;
    }

    protected int getPanpot(int panpot) {
        return panpot;
    }

    protected int getDuration(int duration) {
        return duration;
    }

    protected int getInterval(int interval) {
        return interval;
    }

    protected int getBank(int bank) {
        return bank;
    }

    protected int getInstrument(int bank, int instrument, int number, int option) {
        if (option == 0) {
            instrument = this.soundJDialog.instruments[bank][instrument];
        } else if (option == 1 || option == 2) {
            this.soundJDialog.instrumentsJTextField[this.soundJDialog.bank_old[number]][this.soundJDialog.instrument_old[number]].setForeground(Utils.A1C);
            this.soundJDialog.instrumentsJTextField[this.soundJDialog.bank_old[number]][this.soundJDialog.instrument_old[number]].setBackground(Utils.A2C);
            this.soundJDialog.instrumentsJTextField[this.soundJDialog.bank_old[number]][this.soundJDialog.instrument_old[number]].setText(Integer.toString(this.soundJDialog.instruments[this.soundJDialog.bank_old[number]][this.soundJDialog.instrument_old[number]]));
            this.soundJDialog.instrument_old[number] = instrument;
            instrument = this.soundJDialog.instruments[bank][instrument];
            this.soundJDialog.bank_old[number] = bank;
            this.soundJDialog.instrumentsJTextField[this.soundJDialog.bank_old[number]][this.soundJDialog.instrument_old[number]].setForeground(this.colorReverse[number]);
            this.soundJDialog.instrumentsJTextField[this.soundJDialog.bank_old[number]][this.soundJDialog.instrument_old[number]].setBackground(this.color[number]);
            if (option != 1 && option == 2) {
                this.soundJDialog.instrumentsJTextField[this.soundJDialog.bank_old[number]][this.soundJDialog.instrument_old[number]].setText("\u4f11");
            }
        }
        return instrument;
    }

    protected int getPercussion(int bank, int percussion, int option) {
        if (option == 0) {
            percussion = this.soundJDialog.percussions[bank][percussion];
        } else if (option == 1 || option == 2) {
            this.soundJDialog.percussionsJTextField[this.soundJDialog.bankPercussion_old][this.soundJDialog.percussion_old].setForeground(Utils.A1C);
            this.soundJDialog.percussionsJTextField[this.soundJDialog.bankPercussion_old][this.soundJDialog.percussion_old].setBackground(Utils.A2C);
            this.soundJDialog.percussionsJTextField[this.soundJDialog.bankPercussion_old][this.soundJDialog.percussion_old].setText(Integer.toString(this.soundJDialog.percussions[this.soundJDialog.bankPercussion_old][this.soundJDialog.percussion_old]));
            this.soundJDialog.percussion_old = percussion;
            percussion = this.soundJDialog.percussions[bank][percussion];
            this.soundJDialog.bankPercussion_old = bank;
            this.soundJDialog.percussionsJTextField[this.soundJDialog.bankPercussion_old][this.soundJDialog.percussion_old].setForeground(this.colorReverse9);
            this.soundJDialog.percussionsJTextField[this.soundJDialog.bankPercussion_old][this.soundJDialog.percussion_old].setBackground(this.color9);
            if (option != 1 && option == 2) {
                this.soundJDialog.percussionsJTextField[this.soundJDialog.bankPercussion_old][this.soundJDialog.percussion_old].setText("\u4f11");
            }
        }
        return percussion;
    }

    protected void startSound() {
        block23: {
            try {
                if (this.synthesizer == null) {
                    this.synthesizer = this.soundJDialog.synthesizer;
                }
                if (this.synthesizer == null) {
                    Utils.showErrorMessage(this.soundJDialog, "synthesizer device is not supported.");
                    break block23;
                }
                if (!this.synthesizer.isOpen()) {
                    this.synthesizer.open();
                }
                if (this.synthesizerReceiver == null) {
                    MidiDevice midiDevice = this.soundJDialog.midiDevices[this.soundJDialog.midiDeviceNumber];
                    if (!midiDevice.isOpen()) {
                        midiDevice.open();
                    }
                    this.synthesizerReceiver = midiDevice.getReceiver();
                    if (this.synthesizerReceiver == null) {
                        Utils.showErrorMessage(this.soundJDialog, "synthesizerReceiver device is not supported.");
                    }
                }
                while (this.soundJDialog.soundThread != null) {
                    if (this.soundDirectionOption == 0) {
                        this.j = this.jMin;
                        while (this.j < this.jMax && this.soundJDialog.soundThread != null) {
                            this.soundJDialog.mainJProgressBar.setValue(this.j * this.i + 1);
                            this.soundJDialog.mainJSlider.setValue(this.j * this.i + 1);
                            this.k = this.kMin;
                            while (this.k < this.kMax && this.soundJDialog.soundThread != null) {
                                this.playSoundMidi();
                                ++this.k;
                            }
                            this.soundJDialog.mainJFrame.pictureJPanel.repaint();
                            this.j += this.lineShift;
                        }
                        continue;
                    }
                    if (this.soundDirectionOption == 1) {
                        this.j = this.jMax - 1;
                        while (this.j >= this.jMin && this.soundJDialog.soundThread != null) {
                            this.soundJDialog.mainJProgressBar.setValue(this.j * this.i + 1);
                            this.soundJDialog.mainJSlider.setValue(this.j * this.i + 1);
                            this.k = this.kMax - 1;
                            while (this.k >= this.kMin && this.soundJDialog.soundThread != null) {
                                this.playSoundMidi();
                                --this.k;
                            }
                            this.soundJDialog.mainJFrame.pictureJPanel.repaint();
                            this.j -= this.lineShift;
                        }
                        continue;
                    }
                    if (this.soundDirectionOption == 2) {
                        this.k = this.kMin;
                        while (this.k < this.kMax && this.soundJDialog.soundThread != null) {
                            this.soundJDialog.mainJProgressBar.setValue(this.k * this.i + 1);
                            this.soundJDialog.mainJSlider.setValue(this.k * this.i + 1);
                            this.j = this.jMin;
                            while (this.j < this.jMax && this.soundJDialog.soundThread != null) {
                                this.playSoundMidi();
                                ++this.j;
                            }
                            this.soundJDialog.mainJFrame.pictureJPanel.repaint();
                            this.k += this.lineShift;
                        }
                        continue;
                    }
                    if (this.soundDirectionOption != 3) continue;
                    this.k = this.kMax - 1;
                    while (this.k >= this.kMin && this.soundJDialog.soundThread != null) {
                        this.soundJDialog.mainJProgressBar.setValue(this.k * this.i + 1);
                        this.soundJDialog.mainJSlider.setValue(this.k * this.i + 1);
                        this.j = this.jMax - 1;
                        while (this.j >= this.jMin && this.soundJDialog.soundThread != null) {
                            this.playSoundMidi();
                            --this.j;
                        }
                        this.soundJDialog.mainJFrame.pictureJPanel.repaint();
                        this.k -= this.lineShift;
                    }
                }
            }
            catch (MidiUnavailableException mue) {
                Utils.showErrorMessage(this.soundJDialog, "mue:" + mue.getMessage());
                this.soundJDialog.actionPerformed(new ActionEvent(this.soundJDialog.stopSoundJButton, 0, null));
            }
            catch (SecurityException se) {
                Utils.showErrorMessage(this.soundJDialog, "se:" + se.getMessage());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.soundJDialog.soundThread != null) {
            this.stopSound();
        }
    }

    protected void playSoundMidi() {
        try {
            int l;
            if (this.soundJDialog.jkFlag) {
                this.j = this.soundJDialog.j;
                this.jMin = this.soundJDialog.jMin;
                this.jMax = this.soundJDialog.jMax;
                this.k = this.soundJDialog.k;
                this.kMin = this.soundJDialog.kMin;
                this.kMax = this.soundJDialog.kMax;
                this.soundJDialog.jkFlag = false;
            }
            if (this.cols != this.soundJDialog.cols) {
                this.cols = this.soundJDialog.cols;
                this.color = new Color[this.cols];
                this.colorReverse = new Color[this.cols];
            }
            if (this.lineShift != this.soundJDialog.lineShift) {
                this.lineShift = this.soundJDialog.lineShift;
            }
            if (this.soundJDialog.mainJSliderRepaintFlag) {
                if (this.soundDirectionOption == 0 || this.soundDirectionOption == 1) {
                    this.soundJDialog.mainJSlider.setValue(this.j * this.i + 1);
                } else if (this.soundDirectionOption == 2 || this.soundDirectionOption == 3) {
                    this.soundJDialog.mainJSlider.setValue(this.k * this.i + 1);
                }
                this.soundJDialog.mainJSliderRepaintFlag = false;
            }
            if (this.soundDirectionOption == 0) {
                for (l = 0; l < 16; ++l) {
                    this.jj[l] = this.j + l;
                    while (this.jj[l] >= this.jMax) {
                        int n = l;
                        this.jj[n] = this.jj[n] - (this.jMax - this.jMin);
                    }
                    this.kk[l] = this.k;
                }
            } else if (this.soundDirectionOption == 1) {
                for (l = 0; l < 16; ++l) {
                    this.jj[l] = this.j - l;
                    while (this.jj[l] < this.jMin) {
                        int n = l;
                        this.jj[n] = this.jj[n] + (this.jMax - this.jMin);
                    }
                    this.kk[l] = this.k;
                }
            } else if (this.soundDirectionOption == 2) {
                for (l = 0; l < 16; ++l) {
                    this.jj[l] = this.j;
                    this.kk[l] = this.k + l;
                    while (this.kk[l] >= this.kMax) {
                        int n = l;
                        this.kk[n] = this.kk[n] - (this.kMax - this.kMin);
                    }
                }
            } else if (this.soundDirectionOption == 3) {
                for (l = 0; l < 16; ++l) {
                    this.jj[l] = this.j;
                    this.kk[l] = this.k - l;
                    while (this.kk[l] < this.kMin) {
                        int n = l;
                        this.kk[n] = this.kk[n] + (this.kMax - this.kMin);
                    }
                }
            }
            for (l = 0; l < this.cols; ++l) {
                int ll = l;
                if (l >= 9) {
                    ++ll;
                }
                this.color[l] = new Color(this.tmpImage.getRGB(this.SCW + this.jj[ll] * this.i, this.SCH + this.kk[ll] * this.i));
                this.colorReverse[l] = new Color(255 - this.color[l].getRed(), 255 - this.color[l].getGreen(), 255 - this.color[l].getBlue());
                Utils.drawFillRect(this.soundJDialog.mainJFrame.g, null, this.SCW + this.jj[ll] * this.i, this.SCH + this.kk[ll] * this.i, this.i, this.i, this.colorReverse[l]);
            }
            if (this.soundJDialog.percussionJCheckBox.isSelected()) {
                this.color9 = new Color(this.tmpImage.getRGB(this.SCW + this.jj[9] * this.i, this.SCH + this.kk[9] * this.i));
                this.colorReverse9 = new Color(255 - this.color9.getRed(), 255 - this.color9.getGreen(), 255 - this.color9.getBlue());
                Utils.drawFillRect(this.soundJDialog.mainJFrame.g, null, this.SCW + this.jj[9] * this.i, this.SCH + this.kk[9] * this.i, this.i, this.i, this.colorReverse9);
            }
            this.soundJDialog.setMainJProgressBarString(this.W_W, this.W_H, this.j, this.k, this.i, this.soundDirectionOption);
            int rest = this.soundJDialog.rest;
            int volume = 0;
            int volumeMin = this.soundJDialog.volumeMin;
            int volumeRange = this.soundJDialog.volumeRange;
            int volumePercussion = 0;
            int volumePercussionMin = this.soundJDialog.volumePercussionMin;
            int volumePercussionRange = this.soundJDialog.volumePercussionRange;
            int[] velocity = new int[this.cols];
            int velocityMin = this.soundJDialog.velocityMin;
            int velocityRange = this.soundJDialog.velocityRange;
            int[] pitch = new int[this.cols];
            int pitchMin = this.soundJDialog.pitchMin;
            int pitchRange = this.soundJDialog.pitchRange;
            int duration = 0;
            int durationMin = this.soundJDialog.durationMin;
            int durationRange = this.soundJDialog.durationRange;
            int interval = 0;
            int intervalMin = this.soundJDialog.intervalMin;
            int intervalRange = this.soundJDialog.intervalRange;
            int velocityPercussionMin = this.soundJDialog.velocityPercussionMin;
            int velocityPercussionRange = this.soundJDialog.velocityPercussionRange;
            int panpot = 0;
            int panpotMin = this.soundJDialog.panpotMin;
            int panpotRange = this.soundJDialog.panpotRange;
            int bank = 0;
            int instrument = 0;
            int instrumentCount = 0;
            for (int count = 0; count < this.soundJDialog.bankLength[0]; ++count) {
                for (int countCount = 0; countCount < 128; ++countCount) {
                    if (!this.soundJDialog.instrumentsJToggleButton[count][countCount].isSelected()) continue;
                    ++instrumentCount;
                }
            }
            int[] instrument0 = new int[instrumentCount];
            instrumentCount = 0;
            for (int count = 0; count < this.soundJDialog.bankLength[0]; ++count) {
                for (int countCount = 0; countCount < 128; ++countCount) {
                    if (!this.soundJDialog.instrumentsJToggleButton[count][countCount].isSelected()) continue;
                    instrument0[instrumentCount] = count * 128 + countCount;
                    ++instrumentCount;
                }
            }
            int percussionCount = 0;
            for (int count = 0; count < this.soundJDialog.bankLength[1]; ++count) {
                for (int countCount = 0; countCount < 128; ++countCount) {
                    if (!this.soundJDialog.percussionsJToggleButton[count][countCount].isSelected()) continue;
                    ++percussionCount;
                }
            }
            int[] instrument9 = new int[percussionCount];
            percussionCount = 0;
            for (int count = 0; count < this.soundJDialog.bankLength[1]; ++count) {
                for (int countCount = 0; countCount < 128; ++countCount) {
                    if (!this.soundJDialog.percussionsJToggleButton[count][countCount].isSelected()) continue;
                    instrument9[percussionCount] = count * 128 + countCount;
                    ++percussionCount;
                }
            }
            int pitch9 = 0;
            int velocity9 = 0;
            if (this.colorAssignmentOption == 0 || this.colorAssignmentOption == 1) {
                int l2;
                for (l2 = 0; l2 < this.cols; ++l2) {
                    int ll = l2;
                    if (l2 >= 9) {
                        ++ll;
                    }
                    ShortMessage cc7ShortMessage = new ShortMessage();
                    ShortMessage cc0ShortMessage = new ShortMessage();
                    ShortMessage cc10ShortMessage = new ShortMessage();
                    ShortMessage pcShortMessage = new ShortMessage();
                    ShortMessage onShortMessage = new ShortMessage();
                    pitch[l2] = pitchMin + this.one * pitchRange - this.minus * this.pixels[this.jj[ll]][this.kk[ll]] % (pitchRange + 1);
                    if (instrument0.length != 0) {
                        instrument = 0 + this.one * (instrument0.length - 1) - this.minus * this.getValue(this.jj[ll], this.kk[ll], 4) % instrument0.length;
                        bank = instrument0[instrument] / 128;
                        instrument = instrument0[instrument] % 128;
                    }
                    if (instrument0.length != 0 && this.getValue(this.jj[l2], this.kk[l2], 0) % rest != 0) {
                        volume = volumeMin + this.one * volumeRange - this.minus * this.getValue(this.jj[ll], this.kk[ll], 1) % (volumeRange + 1);
                        cc7ShortMessage.setMessage(176, ll, 7, this.getVolumeHigh(volume));
                        this.synthesizerReceiver.send(cc7ShortMessage, -1L);
                        if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                            this.date = new Date();
                            this.timeNow = this.date.getTime();
                            this.sequencerReceiver.send(cc7ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                        }
                        if (this.colorOrderOption != 6 || l2 == 0) {
                            panpot = panpotMin + this.one * panpotRange - this.minus * this.getValue(this.jj[ll], this.kk[ll], 2) % (panpotRange + 1);
                            cc10ShortMessage.setMessage(176, ll, 10, this.getPanpot(panpot));
                            this.synthesizerReceiver.send(cc10ShortMessage, -1L);
                            cc0ShortMessage.setMessage(176, ll, 0, this.getBank(bank));
                            this.synthesizerReceiver.send(cc0ShortMessage, -1L);
                            pcShortMessage.setMessage(192, ll, this.getInstrument(bank, instrument, l2, 1), 0);
                            this.synthesizerReceiver.send(pcShortMessage, -1L);
                            if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                                this.date = new Date();
                                this.timeNow = this.date.getTime();
                                this.sequencerReceiver.send(cc10ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                                this.sequencerReceiver.send(cc0ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                                this.sequencerReceiver.send(pcShortMessage, (this.timeNow - this.timeStart) * 1000L);
                            }
                        }
                        velocity[l2] = velocityMin + this.one * velocityRange - this.minus * this.getValue(this.jj[ll], this.kk[ll], 5) % (velocityRange + 1);
                        onShortMessage.setMessage(144, ll, this.getPitch(pitch[l2], l2, 1), this.getVelocity(velocity[l2]));
                        this.synthesizerReceiver.send(onShortMessage, -1L);
                        if (this.synthesizerTransmitters != 0 || this.sequencer == null || !this.sequencer.isRecording() || this.sequencerReceiver == null) continue;
                        this.date = new Date();
                        this.timeNow = this.date.getTime();
                        this.sequencerReceiver.send(onShortMessage, (this.timeNow - this.timeStart) * 1000L);
                        continue;
                    }
                    this.getPitch(pitch[l2], l2, 2);
                    if (instrument0.length == 0) continue;
                    this.getInstrument(bank, instrument, l2, 2);
                }
                if (this.soundJDialog.percussionJCheckBox.isSelected() && instrument9.length != 0) {
                    pitch9 = 0 + this.one * (instrument9.length - 1) - this.minus * this.getValue(this.jj[9], this.kk[9], 4) % instrument9.length;
                    bank = instrument9[pitch9] / 128;
                    pitch9 = instrument9[pitch9] % 128;
                    if (this.getValue(this.jj[9], this.kk[9], 0) % rest != 0) {
                        ShortMessage cc7ShortMessage = new ShortMessage();
                        volumePercussion = volumePercussionMin + this.one * volumePercussionRange - this.minus * this.getValue(this.jj[9], this.kk[9], 1) % (volumePercussionRange + 1);
                        cc7ShortMessage.setMessage(176, 9, 7, volumePercussion);
                        this.synthesizerReceiver.send(cc7ShortMessage, -1L);
                        ShortMessage cc0ShortMessage = new ShortMessage();
                        cc0ShortMessage.setMessage(176, 9, 0, bank);
                        this.synthesizerReceiver.send(cc0ShortMessage, -1L);
                        ShortMessage onShortMessage = new ShortMessage();
                        velocity9 = velocityPercussionMin + this.one * velocityPercussionRange - this.minus * this.getValue(this.jj[9], this.kk[9], 5) % (velocityPercussionRange + 1);
                        onShortMessage.setMessage(144, 9, this.getPercussion(bank, pitch9, 1), velocity9);
                        this.synthesizerReceiver.send(onShortMessage, -1L);
                        if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                            this.date = new Date();
                            this.timeNow = this.date.getTime();
                            this.sequencerReceiver.send(cc7ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                            this.sequencerReceiver.send(cc0ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                            this.sequencerReceiver.send(onShortMessage, (this.timeNow - this.timeStart) * 1000L);
                        }
                    } else {
                        this.getPercussion(bank, pitch9, 2);
                    }
                }
                duration = durationMin + this.one * durationRange - this.minus * this.getValue(this.jj[0], this.kk[0], 6) * (durationRange + 1) / this.n;
                Thread.sleep(this.getDuration(duration));
                for (l2 = 0; l2 < this.cols; ++l2) {
                    int ll = l2;
                    if (l2 >= 9) {
                        ++ll;
                    }
                    ShortMessage offShortMessage = new ShortMessage();
                    if (instrument0.length == 0 || this.getValue(this.jj[ll], this.kk[ll], 0) % rest == 0) continue;
                    offShortMessage.setMessage(128, ll, this.getPitch(pitch[l2], l2, 0), this.getVelocity(velocity[l2]));
                    this.synthesizerReceiver.send(offShortMessage, -1L);
                    if (this.synthesizerTransmitters != 0 || this.sequencer == null || !this.sequencer.isRecording() || this.sequencerReceiver == null) continue;
                    this.date = new Date();
                    this.timeNow = this.date.getTime();
                    this.sequencerReceiver.send(offShortMessage, (this.timeNow - this.timeStart) * 1000L);
                }
                if (this.soundJDialog.percussionJCheckBox.isSelected() && instrument9.length != 0 && this.getValue(this.jj[9], this.kk[9], 0) % rest != 0) {
                    ShortMessage offShortMessage = new ShortMessage();
                    offShortMessage.setMessage(128, 9, this.getPercussion(bank, pitch9, 0), velocity9);
                    this.synthesizerReceiver.send(offShortMessage, -1L);
                    if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                        this.date = new Date();
                        this.timeNow = this.date.getTime();
                        this.sequencerReceiver.send(offShortMessage, (this.timeNow - this.timeStart) * 1000L);
                    }
                }
                interval = intervalMin + this.one * intervalRange - this.minus * this.getValue(this.jj[0], this.kk[0], 7) * (intervalRange + 1) / this.n;
                Thread.sleep(this.getInterval(interval));
            } else if (this.colorAssignmentOption == 2 || this.colorAssignmentOption == 3) {
                for (int l3 = 0; l3 < this.cols; ++l3) {
                    int ll = l3;
                    if (l3 >= 9) {
                        ++ll;
                    }
                    ShortMessage cc7ShortMessage = new ShortMessage();
                    ShortMessage cc10ShortMessage = new ShortMessage();
                    ShortMessage cc0ShortMessage = new ShortMessage();
                    ShortMessage pcShortMessage = new ShortMessage();
                    ShortMessage onShortMessage = new ShortMessage();
                    pitch[l3] = pitchMin + this.one * pitchRange - this.minus * this.pixels[this.jj[ll]][this.kk[ll]] * (pitchRange + 1) / this.n;
                    if (instrument0.length != 0) {
                        instrument = 0 + this.one * (instrument0.length - 1) - this.minus * this.getValue(this.jj[ll], this.kk[ll], 4) * instrument0.length / this.n;
                        bank = instrument0[instrument] / 128;
                        instrument = instrument0[instrument] % 128;
                    }
                    if (this.getValue(this.jj[l3], this.kk[l3], 0) % rest != 0) {
                        volume = volumeMin + this.one * volumeRange - this.minus * this.getValue(this.jj[ll], this.kk[ll], 1) * (volumeRange + 1) / this.n;
                        cc7ShortMessage.setMessage(176, ll, 7, this.getVolumeHigh(volume));
                        this.synthesizerReceiver.send(cc7ShortMessage, -1L);
                        if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                            this.date = new Date();
                            this.timeNow = this.date.getTime();
                            this.sequencerReceiver.send(cc7ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                        }
                        if (this.colorOrderOption != 6 || l3 == 0) {
                            panpot = panpotMin + this.one * panpotRange - this.minus * this.getValue(this.jj[ll], this.kk[ll], 2) * (panpotRange + 1) / this.n;
                            cc10ShortMessage.setMessage(176, ll, 10, this.getPanpot(panpot));
                            this.synthesizerReceiver.send(cc10ShortMessage, -1L);
                            cc0ShortMessage.setMessage(176, ll, 0, this.getBank(bank));
                            this.synthesizerReceiver.send(cc0ShortMessage, -1L);
                            pcShortMessage.setMessage(192, ll, this.getInstrument(bank, instrument, l3, 1), 0);
                            this.synthesizerReceiver.send(pcShortMessage, -1L);
                            if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                                this.date = new Date();
                                this.timeNow = this.date.getTime();
                                this.sequencerReceiver.send(cc10ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                                this.sequencerReceiver.send(cc0ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                                this.sequencerReceiver.send(pcShortMessage, (this.timeNow - this.timeStart) * 1000L);
                            }
                        }
                        velocity[l3] = velocityMin + this.one * velocityRange - this.minus * this.getValue(this.jj[ll], this.kk[ll], 5) * (velocityRange + 1) / this.n;
                        onShortMessage.setMessage(144, ll, this.getPitch(pitch[l3], l3, 1), this.getVelocity(velocity[l3]));
                        this.synthesizerReceiver.send(onShortMessage, -1L);
                        if (this.synthesizerTransmitters != 0 || this.sequencer == null || !this.sequencer.isRecording() || this.sequencerReceiver == null) continue;
                        this.date = new Date();
                        this.timeNow = this.date.getTime();
                        this.sequencerReceiver.send(onShortMessage, (this.timeNow - this.timeStart) * 1000L);
                        continue;
                    }
                    this.getPitch(pitch[l3], l3, 2);
                    if (instrument0.length == 0) continue;
                    this.getInstrument(bank, instrument, l3, 2);
                }
                if (this.soundJDialog.percussionJCheckBox.isSelected() && instrument9.length != 0) {
                    pitch9 = 0 + this.one * (instrument9.length - 1) - this.minus * this.getValue(this.jj[9], this.kk[9], 4) * instrument9.length / this.n;
                    bank = instrument9[pitch9] / 128;
                    pitch9 = instrument9[pitch9] % 128;
                    if (this.getValue(this.jj[9], this.kk[9], 0) % rest != 0) {
                        ShortMessage cc7ShortMessage = new ShortMessage();
                        volumePercussion = volumePercussionMin + this.one * volumePercussionRange - this.minus * this.getValue(this.jj[9], this.kk[9], 1) * (volumePercussionRange + 1) / this.n;
                        cc7ShortMessage.setMessage(176, 9, 7, volumePercussion);
                        this.synthesizerReceiver.send(cc7ShortMessage, -1L);
                        ShortMessage cc0ShortMessage = new ShortMessage();
                        cc0ShortMessage.setMessage(176, 9, 0, bank);
                        this.synthesizerReceiver.send(cc0ShortMessage, -1L);
                        ShortMessage onShortMessage = new ShortMessage();
                        velocity9 = velocityPercussionMin + this.one * velocityPercussionRange - this.minus * this.getValue(this.jj[9], this.kk[9], 5) * (velocityPercussionRange + 1) / this.n;
                        onShortMessage.setMessage(144, 9, this.getPercussion(bank, pitch9, 1), velocity9);
                        this.synthesizerReceiver.send(onShortMessage, -1L);
                        if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                            this.date = new Date();
                            this.timeNow = this.date.getTime();
                            this.sequencerReceiver.send(cc7ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                            this.sequencerReceiver.send(cc0ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                            this.sequencerReceiver.send(onShortMessage, (this.timeNow - this.timeStart) * 1000L);
                        }
                    } else {
                        this.getPercussion(bank, pitch9, 2);
                    }
                }
                duration = durationMin + this.one * durationRange - this.minus * this.getValue(this.jj[0], this.kk[0], 6) * (durationRange + 1) / this.n;
                Thread.sleep(this.getDuration(duration));
                for (int l4 = 0; l4 < this.cols; ++l4) {
                    int ll = l4;
                    if (l4 >= 9) {
                        ++ll;
                    }
                    ShortMessage offShortMessage = new ShortMessage();
                    if (this.getValue(this.jj[l4], this.kk[l4], 0) % rest == 0) continue;
                    offShortMessage.setMessage(128, ll, this.getPitch(pitch[l4], l4, 0), this.getVelocity(velocity[l4]));
                    this.synthesizerReceiver.send(offShortMessage, -1L);
                    if (this.synthesizerTransmitters != 0 || this.sequencer == null || !this.sequencer.isRecording() || this.sequencerReceiver == null) continue;
                    this.date = new Date();
                    this.timeNow = this.date.getTime();
                    this.sequencerReceiver.send(offShortMessage, (this.timeNow - this.timeStart) * 1000L);
                }
                if (this.soundJDialog.percussionJCheckBox.isSelected() && instrument9.length != 0 && this.getValue(this.jj[9], this.kk[9], 0) % rest != 0) {
                    ShortMessage offShortMessage = new ShortMessage();
                    offShortMessage.setMessage(128, 9, this.getPercussion(bank, pitch9, 0), velocity9);
                    this.synthesizerReceiver.send(offShortMessage, -1L);
                    if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                        this.date = new Date();
                        this.timeNow = this.date.getTime();
                        this.sequencerReceiver.send(offShortMessage, (this.timeNow - this.timeStart) * 1000L);
                    }
                }
                interval = intervalMin + this.one * intervalRange - this.minus * this.getValue(this.jj[0], this.kk[0], 7) * (intervalRange + 1) / this.n;
                Thread.sleep(this.getInterval(interval));
            } else if (this.colorAssignmentOption == 4) {
                for (int l5 = 0; l5 < this.cols; ++l5) {
                    int ll = l5;
                    if (l5 >= 9) {
                        ++ll;
                    }
                    ShortMessage cc7ShortMessage = new ShortMessage();
                    ShortMessage cc10ShortMessage = new ShortMessage();
                    ShortMessage cc0ShortMessage = new ShortMessage();
                    ShortMessage pcShortMessage = new ShortMessage();
                    ShortMessage onShortMessage = new ShortMessage();
                    pitch[l5] = pitchMin + this.one * pitchRange - this.minus * this.pixels[this.jj[ll]][this.kk[ll]] / this.csp % (pitchRange + 1);
                    if (instrument0.length != 0) {
                        instrument = 0 + this.one * (instrument0.length - 1) - this.minus * this.getValue(this.jj[ll], this.kk[ll], 4) / this.csp % instrument0.length;
                        bank = instrument0[instrument] / 128;
                        instrument = instrument0[instrument] % 128;
                    }
                    if (this.getValue(this.jj[l5], this.kk[l5], 0) % rest != 0) {
                        volume = volumeMin + this.one * volumeRange - this.minus * this.getValue(this.jj[ll], this.kk[ll], 1) / this.csp % (volumeRange + 1);
                        cc7ShortMessage.setMessage(176, ll, 7, this.getVolumeHigh(volume));
                        this.synthesizerReceiver.send(cc7ShortMessage, -1L);
                        if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                            this.date = new Date();
                            this.timeNow = this.date.getTime();
                            this.sequencerReceiver.send(cc7ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                        }
                        if (this.colorOrderOption != 6 || l5 == 0) {
                            panpot = panpotMin + this.one * panpotRange - this.minus * this.getValue(this.jj[ll], this.kk[ll], 2) / this.csp % (panpotRange + 1);
                            cc10ShortMessage.setMessage(176, ll, 10, this.getPanpot(panpot));
                            this.synthesizerReceiver.send(cc10ShortMessage, -1L);
                            cc0ShortMessage.setMessage(176, ll, 0, this.getBank(bank));
                            this.synthesizerReceiver.send(cc0ShortMessage, -1L);
                            pcShortMessage.setMessage(192, ll, this.getInstrument(bank, instrument, l5, 1), 0);
                            this.synthesizerReceiver.send(pcShortMessage, -1L);
                            if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                                this.date = new Date();
                                this.timeNow = this.date.getTime();
                                this.sequencerReceiver.send(cc10ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                                this.sequencerReceiver.send(cc0ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                                this.sequencerReceiver.send(pcShortMessage, (this.timeNow - this.timeStart) * 1000L);
                            }
                        }
                        velocity[l5] = velocityMin + this.one * velocityRange - this.minus * this.getValue(this.jj[ll], this.kk[ll], 5) / this.csp % (velocityRange + 1);
                        onShortMessage.setMessage(144, ll, this.getPitch(pitch[l5], l5, 1), this.getVelocity(velocity[l5]));
                        this.synthesizerReceiver.send(onShortMessage, -1L);
                        if (this.synthesizerTransmitters != 0 || this.sequencer == null || !this.sequencer.isRecording() || this.sequencerReceiver == null) continue;
                        this.date = new Date();
                        this.timeNow = this.date.getTime();
                        this.sequencerReceiver.send(onShortMessage, (this.timeNow - this.timeStart) * 1000L);
                        continue;
                    }
                    this.getPitch(pitch[l5], l5, 2);
                    if (instrument0.length != 0) {
                        this.getInstrument(bank, instrument, l5, 2);
                    }
                    this.getInstrument(bank, instrument, l5, 2);
                }
                if (this.soundJDialog.percussionJCheckBox.isSelected() && instrument9.length != 0) {
                    pitch9 = 0 + this.one * (instrument9.length - 1) - this.minus * this.getValue(this.jj[9], this.kk[9], 4) / this.csp % instrument9.length;
                    bank = instrument9[pitch9] / 128;
                    pitch9 = instrument9[pitch9] % 128;
                    if (this.getValue(this.jj[9], this.kk[9], 0) % rest != 0) {
                        ShortMessage cc7ShortMessage = new ShortMessage();
                        volumePercussion = volumePercussionMin + (this.one * volumePercussionRange - this.minus * this.getValue(this.jj[9], this.kk[9], 1) / this.csp) % (volumePercussionRange + 1);
                        cc7ShortMessage.setMessage(176, 9, 7, volumePercussion);
                        this.synthesizerReceiver.send(cc7ShortMessage, -1L);
                        ShortMessage cc0ShortMessage = new ShortMessage();
                        cc0ShortMessage.setMessage(176, 9, 0, bank);
                        this.synthesizerReceiver.send(cc0ShortMessage, -1L);
                        ShortMessage onShortMessage = new ShortMessage();
                        velocity9 = velocityPercussionMin + this.one * velocityPercussionRange - this.minus * this.getValue(this.jj[9], this.kk[9], 5) / this.csp % (velocityPercussionRange + 1);
                        onShortMessage.setMessage(144, 9, this.getPercussion(bank, pitch9, 1), velocity9);
                        this.synthesizerReceiver.send(onShortMessage, -1L);
                        if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                            this.date = new Date();
                            this.timeNow = this.date.getTime();
                            this.sequencerReceiver.send(cc7ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                            this.sequencerReceiver.send(cc0ShortMessage, (this.timeNow - this.timeStart) * 1000L);
                            this.sequencerReceiver.send(onShortMessage, (this.timeNow - this.timeStart) * 1000L);
                        }
                    } else {
                        this.getPercussion(bank, pitch9, 2);
                    }
                }
                duration = durationMin + this.one * durationRange - this.minus * this.getValue(this.jj[0], this.kk[0], 6) * (durationRange + 1) / this.n;
                Thread.sleep(this.getDuration(duration));
                for (int l6 = 0; l6 < this.cols; ++l6) {
                    int ll = l6;
                    if (l6 >= 9) {
                        ++ll;
                    }
                    ShortMessage offShortMessage = new ShortMessage();
                    if (this.getValue(this.jj[l6], this.kk[l6], 0) % rest == 0) continue;
                    offShortMessage.setMessage(128, ll, this.getPitch(pitch[l6], l6, 0), this.getVelocity(velocity[l6]));
                    this.synthesizerReceiver.send(offShortMessage, -1L);
                    if (this.synthesizerTransmitters != 0 || this.sequencer == null || !this.sequencer.isRecording() || this.sequencerReceiver == null) continue;
                    this.date = new Date();
                    this.timeNow = this.date.getTime();
                    this.sequencerReceiver.send(offShortMessage, (this.timeNow - this.timeStart) * 1000L);
                }
                if (this.soundJDialog.percussionJCheckBox.isSelected() && instrument9.length != 0 && this.getValue(this.jj[9], this.kk[9], 0) % rest != 0) {
                    ShortMessage offShortMessage = new ShortMessage();
                    offShortMessage.setMessage(128, 9, this.getPercussion(bank, pitch9, 0), velocity9);
                    this.synthesizerReceiver.send(offShortMessage, -1L);
                    if (this.synthesizerTransmitters == 0 && this.sequencer != null && this.sequencer.isRecording() && this.sequencerReceiver != null) {
                        this.date = new Date();
                        this.timeNow = this.date.getTime();
                        this.sequencerReceiver.send(offShortMessage, (this.timeNow - this.timeStart) * 1000L);
                    }
                }
                interval = intervalMin + this.one * intervalRange - this.minus * this.getValue(this.jj[0], this.kk[0], 7) * (intervalRange + 1) / this.n;
                Thread.sleep(this.getInterval(interval));
            }
        }
        catch (InvalidMidiDataException imde) {
            Utils.showErrorMessage(this.soundJDialog, "imde:" + imde.getMessage());
        }
        catch (SecurityException se) {
            Utils.showErrorMessage(this.soundJDialog, "se:" + se.getMessage());
        }
        catch (IllegalStateException ise) {
        }
        catch (InterruptedException ie) {
            Utils.showErrorMessage(this.soundJDialog, "ie:" + ie.getMessage());
        }
    }

    protected void stopSound() {
        try {
            this.synthesizerReceiver.close();
            this.synthesizer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void startMidiRecording() {
        this.tracks = 22;
        try {
            if (this.synthesizer == null) {
                this.synthesizer = this.soundJDialog.soundThread.synthesizer;
            }
            if (this.sequencer == null) {
                MidiDevice device = null;
                MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
                for (int i = 0; i < info.length; ++i) {
                    try {
                        device = MidiSystem.getMidiDevice(info[i]);
                        if (!info[i].getName().matches(".*?Sequencer.*?")) continue;
                        this.sequencer = (Sequencer)device;
                        if (!this.sequencer.isOpen()) {
                            this.sequencer.open();
                        }
                        this.sequencerTransmitter = this.sequencer.getTransmitter();
                        break;
                    }
                    catch (MidiUnavailableException mue) {
                        // empty catch block
                    }
                }
            }
            this.soundJDialog.sequence = new Sequence(0.0f, 10, this.tracks);
            if (this.synthesizer != null && this.sequencer != null) {
                if (!this.synthesizer.isOpen()) {
                    this.synthesizer.open();
                }
                if (!this.sequencer.isOpen()) {
                    this.sequencer.open();
                }
                this.synthesizerTransmitters = this.synthesizer.getMaxTransmitters();
                this.synthesizerTransmitters = this.synthesizer.getMaxTransmitters();
                if (this.synthesizerTransmitter == null && this.synthesizerTransmitters != 0) {
                    this.synthesizerTransmitter = this.synthesizer.getTransmitter();
                }
                if (this.sequencerReceiver == null) {
                    this.sequencerReceiver = this.sequencer.getReceiver();
                }
                if (this.synthesizerTransmitters != 0) {
                    this.synthesizerTransmitter.setReceiver(this.sequencerReceiver);
                }
                this.track = this.soundJDialog.sequence.getTracks();
                this.sequencer.setSequence(this.soundJDialog.sequence);
                for (int count = 6; count < this.tracks; ++count) {
                    this.sequencer.recordEnable(this.track[count], count - 6);
                }
                SysexMessage F07ESysexMessage = new SysexMessage();
                byte[] F07EByte = new byte[]{126, 127, 9, 3};
                F07ESysexMessage.setMessage(240, F07EByte, F07EByte.length);
                MidiEvent F07EMidiEvent = new MidiEvent(F07ESysexMessage, 0L);
                this.track[0].add(F07EMidiEvent);
                String t1MetaMessageString = "The Fractal Sound created by JFractal Ver." + Utils.getVersionString(8000601) + ".";
                MetaMessage t1MetaMessage = new MetaMessage();
                t1MetaMessage.setMessage(1, t1MetaMessageString.getBytes(), t1MetaMessageString.length());
                MidiEvent t1MidiEvent = new MidiEvent(t1MetaMessage, 0L);
                this.track[0].add(t1MidiEvent);
                String t2MetaMessageString = "Copyright (c) 2003 by Hayashida Shigheo";
                MetaMessage t2MetaMessage = new MetaMessage();
                t2MetaMessage.setMessage(2, t2MetaMessageString.getBytes(), t2MetaMessageString.length());
                MidiEvent t2MidiEvent = new MidiEvent(t2MetaMessage, 0L);
                this.track[0].add(t2MidiEvent);
                String t30MetaMessageString = "";
                MetaMessage t30MetaMessage = new MetaMessage();
                t30MetaMessage.setMessage(3, t30MetaMessageString.getBytes(), t30MetaMessageString.length());
                MidiEvent t30MidiEvent = new MidiEvent(t30MetaMessage, 0L);
                this.track[0].add(t30MidiEvent);
                String t31MetaMessageString = "The Fractal Sound";
                MetaMessage t31MetaMessage = new MetaMessage();
                t31MetaMessage.setMessage(3, t31MetaMessageString.getBytes(), t31MetaMessageString.length());
                MidiEvent t31MidiEvent = new MidiEvent(t31MetaMessage, 0L);
                this.track[1].add(t31MidiEvent);
                String t32MetaMessageString = " created by JFractal.";
                MetaMessage t32MetaMessage = new MetaMessage();
                t32MetaMessage.setMessage(3, t32MetaMessageString.getBytes(), t32MetaMessageString.length());
                MidiEvent t32MidiEvent = new MidiEvent(t32MetaMessage, 0L);
                this.track[2].add(t32MidiEvent);
                String t33MetaMessageString = "Copyright (c) 2003 by";
                MetaMessage t33MetaMessage = new MetaMessage();
                t33MetaMessage.setMessage(3, t33MetaMessageString.getBytes(), t33MetaMessageString.length());
                MidiEvent t33MidiEvent = new MidiEvent(t33MetaMessage, 0L);
                this.track[3].add(t33MidiEvent);
                String t34MetaMessageString = " Hayashida Shigheo.";
                MetaMessage t34MetaMessage = new MetaMessage();
                t34MetaMessage.setMessage(3, t34MetaMessageString.getBytes(), t34MetaMessageString.length());
                MidiEvent t34MidiEvent = new MidiEvent(t34MetaMessage, 0L);
                this.track[4].add(t34MidiEvent);
                for (int count = 6; count < this.tracks; ++count) {
                    String t3MetaMessageString = "Channel " + (count - 6 + 1);
                    MetaMessage t3MetaMessage = new MetaMessage();
                    t3MetaMessage.setMessage(3, t3MetaMessageString.getBytes(), t3MetaMessageString.length());
                    MidiEvent t3MidiEvent = new MidiEvent(t3MetaMessage, 0L);
                    this.track[count].add(t3MidiEvent);
                }
                if (this.synthesizerTransmitters == 0) {
                    this.date = new Date();
                    this.timeStart = this.date.getTime();
                }
                this.sequencer.startRecording();
            }
        }
        catch (MidiUnavailableException mue) {
            Utils.showErrorMessage(this.soundJDialog, mue.getMessage());
        }
        catch (InvalidMidiDataException imde) {
            Utils.showErrorMessage(this.soundJDialog, imde.getMessage());
        }
    }

    protected void stopMidiRecording() {
        if (this.sequencer.isRecording()) {
            this.sequencer.stopRecording();
        }
        this.sequencer.close();
        this.sequencerReceiver.close();
    }

    protected void startSequence() {
        try {
            if (this.synthesizer == null) {
                this.synthesizer = MidiSystem.getSynthesizer();
            }
            if (this.sequencer == null) {
                MidiDevice device = null;
                MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
                for (int i = 0; i < info.length; ++i) {
                    try {
                        device = MidiSystem.getMidiDevice(info[i]);
                        if (!info[i].getName().matches(".*?Sequencer.*?")) continue;
                        this.sequencer = (Sequencer)device;
                        if (!this.sequencer.isOpen()) {
                            this.sequencer.open();
                        }
                        this.sequencerTransmitter = this.sequencer.getTransmitter();
                        break;
                    }
                    catch (MidiUnavailableException mue) {
                        // empty catch block
                    }
                }
            }
            if (this.synthesizer == null || this.sequencer == null) {
                if (this.synthesizer == null) {
                    Utils.showErrorMessage(this.soundJDialog, "synthesizer device is not supported.");
                }
                if (this.sequencer == null) {
                    Utils.showErrorMessage(this.soundJDialog, "sequencer device is not supported.");
                }
            } else {
                if (!this.sequencer.isOpen()) {
                    this.sequencer.open();
                }
                this.sequencer.setSequence(this.soundJDialog.sequence);
                if (!this.synthesizer.isOpen()) {
                    this.synthesizer.open();
                }
                if (this.synthesizerReceiver == null) {
                    this.synthesizerReceiver = this.synthesizer.getReceiver();
                }
                this.sequencerTransmitter.setReceiver(this.synthesizerReceiver);
                this.sequencer.start();
                Long sequenceLength = new Long(this.sequencer.getMicrosecondLength() / 1000000L);
                this.soundJDialog.setMainJPanel("\u4f4d\u7f6e - \u518d\u751f\uff08\u5358\u4f4d\uff1a\u79d2\uff09", "\u9332\u97f3\u3057\u305f\u30b5\u30a6\u30f3\u30c9\u306e\u518d\u751f\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\uff01", 0, sequenceLength.intValue(), 1, 10, 10, 0);
                while (this.soundJDialog.soundPlayThread != null) {
                    Long sequencePosition = new Long(this.sequencer.getMicrosecondPosition() / 1000000L);
                    this.soundJDialog.setMainJProgressBarString(this.sequencer.getMicrosecondLength(), this.sequencer.getMicrosecondPosition());
                    this.soundJDialog.mainJProgressBar.setValue(sequencePosition.intValue());
                    this.soundJDialog.mainJSlider.setValue(sequencePosition.intValue());
                    if (this.sequencer.isRunning()) continue;
                    if (this.synthesizerTransmitters == 0) {
                        this.sequencer.stop();
                    }
                    this.sequencer.start();
                    if (this.synthesizerTransmitters != 0) continue;
                    this.sequencer.setMicrosecondPosition(0L);
                }
            }
        }
        catch (MidiUnavailableException mue) {
            Utils.showErrorMessage(this.soundJDialog, mue.getMessage());
        }
        catch (InvalidMidiDataException imde) {
            Utils.showErrorMessage(this.soundJDialog, imde.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void stopSequence() {
        if (this.sequencer.isRunning()) {
            this.sequencer.stop();
        }
        this.sequencer.close();
        this.synthesizer.close();
        this.sequencerTransmitter.close();
        this.synthesizerReceiver.close();
    }

    protected void startSampledRecording() {
        try {
            Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
            Mixer mixer = AudioSystem.getMixer(mixerInfo[2]);
            Line.Info[] targetLineInfo = mixer.getTargetLineInfo();
            this.targetDataLine = (TargetDataLine)AudioSystem.getLine(targetLineInfo[0]);
            this.soundJDialog.targetAudioFormat = new AudioFormat(44100.0f, 16, 2, true, true);
            this.targetDataLine.open(this.soundJDialog.targetAudioFormat);
            byte[] data = new byte[this.targetDataLine.getBufferSize() / 5];
            this.targetDataLine.start();
            while (this.soundJDialog.soundThread != null) {
                while (this.soundJDialog.soundThread != null && this.soundJDialog.recordingJToggleButton.isSelected()) {
                    int numBytesRead = this.targetDataLine.read(data, 0, data.length);
                    this.soundJDialog.byteArrayOutputStream.write(data, 0, numBytesRead);
                }
            }
        }
        catch (LineUnavailableException lue) {
            Utils.showErrorMessage(this.soundJDialog, lue.getMessage());
        }
        catch (IllegalStateException ise) {
            Utils.showErrorMessage(this.soundJDialog, ise.getMessage());
        }
        catch (SecurityException se) {
            Utils.showErrorMessage(this.soundJDialog, se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            Utils.showErrorMessage(this.soundJDialog, iae.getMessage());
        }
        if (this.soundJDialog.soundThread != null) {
            this.stopSampledRecording();
        }
    }

    protected void stopSampledRecording() {
        try {
            this.targetDataLine.stop();
            this.targetDataLine.close();
        }
        catch (Exception e) {
            Utils.showErrorMessage(this.soundJDialog, e.getMessage());
        }
    }

    protected void startSampled() {
        try {
            Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
            Mixer mixer = AudioSystem.getMixer(mixerInfo[0]);
            Line.Info[] sourceLineInfo = mixer.getSourceLineInfo();
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(sourceLineInfo[0]);
            this.soundJDialog.sourceAudioFormat = new AudioFormat(44100.0f, 16, 2, true, true);
            this.sourceDataLine.open(this.soundJDialog.sourceAudioFormat);
            this.sourceDataLine.start();
        }
        catch (LineUnavailableException lue) {
            Utils.showErrorMessage(this.soundJDialog, lue.getMessage());
        }
        catch (IllegalStateException ise) {
            Utils.showErrorMessage(this.soundJDialog, ise.getMessage());
        }
        catch (SecurityException se) {
            Utils.showErrorMessage(this.soundJDialog, se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            Utils.showErrorMessage(this.soundJDialog, iae.getMessage());
        }
        if (this.soundJDialog.soundPlayThread != null) {
            this.stopSampled();
        }
    }

    protected void stopSampled() {
        try {
            this.sourceDataLine.stop();
            this.sourceDataLine.close();
        }
        catch (Exception e) {
            Utils.showErrorMessage(this.soundJDialog, e.getMessage());
        }
    }

    protected void startRecording() {
        this.startMidiRecording();
    }

    protected void stopRecording() {
        this.stopMidiRecording();
    }

    protected void startPlay() {
        this.startSequence();
    }

    protected void stopPlay() {
        this.stopSequence();
    }
}

