/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public class PictureDataPainter
extends Component
implements Printable {
    private static final long serialVersionUID = 1L;
    private MainJFrame mainJFrame;
    private int option;
    private int W_W;
    private int W_H;
    private int SCW;
    private int SCH;
    private BufferedImage tmpImage;
    private Image offImage;

    public PictureDataPainter(MainJFrame mainJFrame, int option) {
        this.mainJFrame = mainJFrame;
        this.option = option;
        this.W_W = mainJFrame.W_W;
        this.W_H = mainJFrame.W_H;
        this.SCW = mainJFrame.SCW;
        this.SCH = mainJFrame.SCH;
        if (option == 0) {
            this.tmpImage = mainJFrame.tmpImage;
        } else if (option == 1) {
            this.offImage = mainJFrame.tripleJDialog.offImage;
        } else if (option == 2) {
            this.offImage = mainJFrame.cellularAutomataJDialog.offImage;
        } else if (option == 3) {
            this.offImage = mainJFrame.tileAutomataJDialog.offImage;
        }
    }

    public PictureDataPainter(BufferedImage bufferedImage, int option) {
        this.tmpImage = bufferedImage;
        this.option = option;
    }

    @Override
    public int print(Graphics g, PageFormat fmt, int pageIndex) {
        if (pageIndex > 1) {
            return 1;
        }
        double ix = fmt.getImageableX();
        double iy = fmt.getImageableY();
        switch (this.option) {
            case 0: {
                g.drawImage(this.tmpImage, (int)ix, (int)iy, (int)ix + this.W_W, (int)iy + this.W_H, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this);
                break;
            }
            case 1: {
                int width = this.mainJFrame.tripleJDialog.width;
                int height = this.mainJFrame.tripleJDialog.height;
                g.drawImage(this.offImage, (int)ix, (int)iy, (int)ix + width, (int)iy + height, 0, 0, width, height, this);
                break;
            }
            case 2: {
                int width = this.mainJFrame.cellularAutomataJDialog.width;
                int height = this.mainJFrame.cellularAutomataJDialog.height;
                g.drawImage(this.offImage, (int)ix, (int)iy, (int)ix + width, (int)iy + height, 0, 0, width, height, this);
                break;
            }
            case 3: {
                int width = this.mainJFrame.tileAutomataJDialog.width;
                int height = this.mainJFrame.tileAutomataJDialog.height;
                g.drawImage(this.offImage, (int)ix, (int)iy, (int)ix + width, (int)iy + height, 0, 0, width, height, this);
                break;
            }
            case 4: {
                this.dataPrint(g, (int)ix, (int)iy);
                break;
            }
            case 5: {
                int width = this.tmpImage.getWidth();
                int height = this.tmpImage.getHeight();
                g.drawImage(this.tmpImage, (int)ix, (int)iy, (int)ix + width, (int)iy + height, 0, 0, width, height, this);
            }
        }
        return 0;
    }

    public void dataPrint(Graphics g, int x, int y) {
        g.setColor(Utils.DFC);
        g.setFont(Utils.DPF);
        int height = 16;
        try {
            int len0;
            int len;
            String str = this.mainJFrame.dataJTextArea.getText();
            g.drawString("JFractal\uff08\u30d5\u30e9\u30af\u30bf\u30eb\u753b\u50cf\u4f5c\u6210\u30d7\u30ed\u30b0\u30e9\u30e0\uff09\u30c7\u30fc\u30bf\u30b7\u30fc\u30c8", x, y += height);
            g.drawString("", x, y += height);
            int startIdx = 0;
            int endIdx = 0;
            char[] data = new char[len];
            str.getChars(0, len, data, 0);
            for (len = len0 = str.length(); len > 0; len -= endIdx - startIdx + 1) {
                y += height;
                endIdx = str.indexOf("\n", startIdx);
                if (endIdx == -1) {
                    endIdx = len0;
                }
                if (endIdx > startIdx) {
                    g.drawChars(data, startIdx, endIdx - startIdx, x, y);
                }
                startIdx = endIdx + 1;
            }
        }
        catch (NullPointerException npe) {
            Utils.showErrorMessage(this, npe.getMessage());
        }
    }
}

