/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class OriginalFileFilter
extends FileFilter {
    int fileExtensionOption;

    public OriginalFileFilter(int option) {
        this.fileExtensionOption = option;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String extension = Utils.getExtension(file);
        if (extension != null) {
            switch (this.fileExtensionOption) {
                case 0: {
                    return extension.equals("jft");
                }
                case 1: {
                    return extension.equals("jfp");
                }
                case 2: {
                    return extension.equals("jfd");
                }
                case 3: {
                    return extension.equals("xml");
                }
                case 4: {
                    return extension.equals("jpeg") || extension.equals("jpg") || extension.equals("png");
                }
                case 40: {
                    return extension.equals("jpeg") || extension.equals("jpg") || extension.equals("png") || extension.equals("gif") || extension.equals("bmp") || extension.equals("wbmp");
                }
                case 400: {
                    return extension.equals("jpeg") || extension.equals("jpg");
                }
                case 401: {
                    return extension.equals("png");
                }
                case 402: {
                    return extension.equals("gif");
                }
                case 403: {
                    return extension.equals("bmp");
                }
                case 404: {
                    return extension.equals("wbmp");
                }
                case 5: {
                    return extension.equals("text") || extension.equals("txt");
                }
                case 6: {
                    return extension.equals("jfd") || extension.equals("jfp") || extension.equals("jft") || extension.equals("xml");
                }
                case 7: {
                    return extension.equals("xml") || extension.equals("jpg");
                }
                case 8: {
                    return extension.equals("jfc");
                }
                case 9: {
                    return extension.equals("ifs");
                }
                case 10: {
                    return extension.equals("mid");
                }
                case 11: {
                    return extension.equals("dem");
                }
                case 12: {
                    return extension.equals("raw");
                }
                case 13: {
                    return extension.equals("pov");
                }
                case 14: {
                    return extension.equals("wrl");
                }
                case 15: {
                    return extension.equals("mtx");
                }
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        String description = null;
        switch (this.fileExtensionOption) {
            case 0: {
                description = "\u753b\u50cf\u3068\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e JFractal \u5c02\u7528\u30d5\u30a1\u30a4\u30eb\uff08*.jft\uff09";
                break;
            }
            case 1: {
                description = "\u753b\u50cf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e JFractal \u5c02\u7528\u30d5\u30a1\u30a4\u30eb\uff08*.jfp\uff09";
                break;
            }
            case 2: {
                description = "\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e JFractal \u5c02\u7528\u30d5\u30a1\u30a4\u30eb\uff08*.jfd\uff09";
                break;
            }
            case 3: {
                description = "\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e XML \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.xml\uff09";
                break;
            }
            case 4: {
                description = "\u753b\u50cf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e JPEG \u3068PNG \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.jpg, *.jpeg, *.png\uff09";
                break;
            }
            case 40: {
                description = "\u30a4\u30f3\u30dd\u30fc\u30c8\u53ef\u80fd\u306a\u3059\u3079\u3066\u306e\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\uff08*.jpg, *.jpeg, *.png, *.gif, *.bmp, *.wbmp\uff09";
                break;
            }
            case 400: {
                description = "\u753b\u50cf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e JPEG \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.jpg, *.jpeg\uff09";
                break;
            }
            case 401: {
                description = "\u753b\u50cf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e PNG \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.png\uff09";
                break;
            }
            case 5: {
                description = "\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e Text \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.txt, *.text\uff09";
                break;
            }
            case 6: {
                description = "JFractal \u5c02\u7528\u30d5\u30a1\u30a4\u30eb\u3068 XML \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.jfd, *.jft, *.xml\uff09";
                break;
            }
            case 7: {
                description = "\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e XML \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u3068\u753b\u50cf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e JPEG \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.xml, *.jpg\uff09";
                break;
            }
            case 8: {
                description = "\u30ab\u30e9\u30fc\u30c6\u30fc\u30d6\u30eb\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e JFractal \u5c02\u7528\u30d5\u30a1\u30a4\u30eb\uff08*.jfc\uff09";
                break;
            }
            case 9: {
                description = "\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e iFractalSound \u5c02\u7528\u30d5\u30a1\u30a4\u30eb\uff08*.ifs\uff09";
                break;
            }
            case 10: {
                description = "\u30b5\u30a6\u30f3\u30c9\u30fb\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e Midi \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.mid\uff09";
                break;
            }
            case 11: {
                description = "\u6570\u5024\u5730\u5f62\u30e2\u30c7\u30eb\u30fb\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e DEM \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.dem\uff09";
                break;
            }
            case 12: {
                description = "\u30bb\u30ab\u30f3\u30c9\u30e9\u30a4\u30d5\u7528\u6a19\u9ad8\u30d5\u30a3\u30fc\u30eb\u30c9\u5730\u56f3\u30fb\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e RAW \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\uff08*.raw\uff09";
                break;
            }
            case 13: {
                description = "POV-Ray \u7528\u306e\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e POV \u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb\uff08*.pov\uff09";
                break;
            }
            case 14: {
                description = "VRML 2.0 \u7528\u306e\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e WRL \u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb\uff08*.wrl\uff09";
                break;
            }
            case 15: {
                description = "VET \u7528\u306e\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3059\u308b\u305f\u3081\u306e MTX \u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb\uff08*.mtx\uff09";
            }
        }
        return description;
    }
}

