/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.TransferHandler;

public class ImageSelection
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        if (!(comp instanceof JLabel)) {
            return false;
        }
        int n = flavor.length;
        for (int i = 0; i < n; ++i) {
            int m = flavors.length;
            for (int j = 0; j < m; ++j) {
                if (!flavor[i].equals(flavors[j])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Transferable createTransferable(JComponent comp) {
        JLabel label;
        Icon icon;
        if (comp instanceof JLabel && (icon = (label = (JLabel)comp).getIcon()) instanceof ImageIcon) {
            final Image image = ((ImageIcon)icon).getImage();
            Transferable transferable = new Transferable(){

                @Override
                public Object getTransferData(DataFlavor flavor) {
                    if (this.isDataFlavorSupported(flavor)) {
                        return image;
                    }
                    return null;
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return flavors;
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return flavor.equals(DataFlavor.imageFlavor);
                }
            };
            return transferable;
        }
        return null;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            if (t.isDataFlavorSupported(flavors[0])) {
                try {
                    Image image = (Image)t.getTransferData(flavors[0]);
                    ImageIcon icon = new ImageIcon(image);
                    label.setIcon(icon);
                    return true;
                }
                catch (UnsupportedFlavorException ignored) {
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

