/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImagePreview
extends JComponent
implements PropertyChangeListener,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon tmpIcon;
    protected ImageIcon thumbnail = null;
    protected File file = null;
    protected JCheckBox openDataXmlJCheckBox;
    protected JCheckBox saveDataXmlJCheckBox;
    protected JCheckBox savePictureJpegJCheckBox;
    protected JSlider savePictureJpegJSlider;
    protected JLabel savePictureJpegJLabel;
    protected JPanel savePictureJpegJPanel;
    protected JTextField savePictureJpegJTextField;
    protected JComboBox<String> pictureFileFormatJComboBox;
    protected JComboBox<String> colorOptionJComboBox;
    protected JComboBox<String> shapeOptionJComboBox;
    private boolean flag;
    private int pictureFileFormat;
    private int quality;
    private int colorOption;
    private int shapeOption;
    private JPanel northJPanel;
    private JPanel southJPanel;
    private JLabel jlabel;
    private JTextField jtextField;
    private JSlider jslider;
    private JCheckBox jcheckBox;
    private MainJFrame mainJFrame;
    private JFileChooser fc;
    private JSlider saveDataIfsXJSlider;
    private JSlider saveDataIfsYJSlider;
    private int dataCols = 48;
    private int dataRows = 36;
    private int centerX;
    private int centerY;
    protected int pointX = 0;
    protected int pointY = 0;
    private int SCW;
    private int SCH;
    private int W_W;
    private int W_H;

    public ImagePreview(JFileChooser fc) {
        this.fc = fc;
        fc.addPropertyChangeListener(this);
        this.setPreferredSize(new Dimension(136, 90));
    }

    public ImagePreview(JFileChooser fc, int quality, boolean flag, int option) {
        this.fc = fc;
        this.quality = quality;
        this.flag = flag;
        fc.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout(0, 0));
        this.northJPanel = new JPanel();
        this.northJPanel.setLayout(new BorderLayout(0, 0));
        this.southJPanel = new JPanel();
        this.southJPanel.setLayout(new BorderLayout(0, 0));
        this.jlabel = new JLabel(" JPEG \u306e\u54c1\u8cea");
        this.jtextField = new JTextField(Integer.toString(quality), 3);
        this.jtextField.addActionListener(this);
        this.jslider = new JSlider(0, 100, quality);
        this.jslider.addChangeListener(this);
        this.jslider.setMajorTickSpacing(25);
        this.jslider.setMinorTickSpacing(5);
        this.jslider.setPaintTicks(true);
        this.jslider.setPaintLabels(true);
        this.northJPanel.add((Component)this.jlabel, "West");
        this.northJPanel.add((Component)this.jslider, "South");
        this.northJPanel.add((Component)this.jtextField, "East");
        this.setPreferredSize(new Dimension(204, 280));
        this.pictureFileFormatJComboBox = new JComboBox<String>(new String[]{"\u25cf \u753b\u50cf\u306e\u4fdd\u5b58\u5f62\u5f0f :: JPEG", "\u25cf \u753b\u50cf\u306e\u4fdd\u5b58\u5f62\u5f0f :: PNG"});
        this.pictureFileFormatJComboBox.addActionListener(this);
        this.southJPanel.add(this.pictureFileFormatJComboBox, "Center");
        this.add((Component)this.northJPanel, "North");
        this.add((Component)this.southJPanel, "South");
    }

    public ImagePreview(JFileChooser fc, int colorOption, int shapeOption, int option) {
        this.fc = fc;
        this.colorOption = colorOption;
        this.shapeOption = shapeOption;
        fc.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout(0, 0));
        this.colorOptionJComboBox = new JComboBox<String>(new String[]{"\u25cf \u8272 :: \u753b\u50cf\u304b\u3089\u53d6\u5f97", "\u25cf \u8272 :: \u3059\u3079\u3066\u540c\u3058\u8272"});
        this.colorOptionJComboBox.setSelectedIndex(colorOption);
        this.setPreferredSize(new Dimension(204, 240));
        switch (option) {
            case 0: {
                this.shapeOptionJComboBox = new JComboBox<String>(new String[]{"\u25cf \u5f62 :: \u6b63\u65b9\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u7acb\u65b9\u4f53", "\u25cf \u5f62 :: \u56db\u89d2\u67f1", "\u25cf \u5f62 :: \u5186\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u7403", "\u25cf \u5f62 :: \u5186\u67f1", "\u25cf \u5f62 :: \u30e1\u30c3\u30b7\u30e5\uff11"});
                break;
            }
            case 1: {
                this.shapeOptionJComboBox = new JComboBox<String>(new String[]{"\u25cf \u5f62 :: \u6b63\u65b9\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u7acb\u65b9\u4f53", "\u25cf \u5f62 :: \u56db\u89d2\u67f1", "\u25cf \u5f62 :: \u5186\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u7403", "\u25cf \u5f62 :: \u5186\u67f1", "\u25cf \u5f62 :: \u70b9", "\u25cf \u5f62 :: \u9ad8\u3055\u65b9\u5411\u306e\u7dda\uff11", "\u25cf \u5f62 :: \u9ad8\u3055\u65b9\u5411\u306e\u7dda\uff12", "\u25cf \u5f62 :: \u30d5\u30a7\u30fc\u30b9\uff11", "\u25cf \u5f62 :: \u30d5\u30a7\u30fc\u30b9\uff12", "\u25cf \u5f62 :: \u30b0\u30ea\u30c3\u30c9\uff11", "\u25cf \u5f62 :: \u30b0\u30ea\u30c3\u30c9\uff12"});
                break;
            }
            case 2: {
                this.shapeOptionJComboBox = new JComboBox<String>(new String[]{"\u25cf \u5f62 :: \u6b63\u65b9\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u7acb\u65b9\u4f53", "\u25cf \u5f62 :: \u56db\u89d2\u67f1", "\u25cf \u5f62 :: \u5186\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u7403", "\u25cf \u5f62 :: \u5186\u67f1"});
            }
        }
        this.shapeOptionJComboBox.setSelectedIndex(shapeOption);
        this.colorOptionJComboBox.addActionListener(this);
        this.shapeOptionJComboBox.addActionListener(this);
        this.add(this.colorOptionJComboBox, "North");
        this.add(this.shapeOptionJComboBox, "South");
    }

    public ImagePreview(MainJFrame mainJFrame, JFileChooser fc) {
        this.fc = fc;
        this.mainJFrame = mainJFrame;
        fc.addPropertyChangeListener(this);
        this.setPreferredSize(new Dimension(136, 96));
    }

    public ImagePreview(MainJFrame mainJFrame, JFileChooser fc, int quality) {
        this.mainJFrame = mainJFrame;
        this.fc = fc;
        this.quality = quality;
        fc.addPropertyChangeListener(this);
        this.setPreferredSize(new Dimension(204, 240));
        this.setLayout(new BorderLayout(0, 0));
        this.northJPanel = new JPanel();
        this.northJPanel.setLayout(new BorderLayout(0, 0));
        this.jlabel = new JLabel(" \u30b5\u30e0\u30cd\u30fc\u30eb\u7528 Jpeg \u306e\u54c1\u8cea");
        this.jtextField = new JTextField(Integer.toString(quality), 3);
        this.jtextField.addActionListener(this);
        this.jslider = new JSlider(0, 100, quality);
        this.jslider.addChangeListener(this);
        this.jslider.setMajorTickSpacing(25);
        this.jslider.setMinorTickSpacing(5);
        this.jslider.setPaintTicks(true);
        this.jslider.setPaintLabels(true);
        this.northJPanel.add((Component)this.jlabel, "West");
        this.northJPanel.add((Component)this.jslider, "South");
        this.northJPanel.add((Component)this.jtextField, "East");
        this.add((Component)this.northJPanel, "North");
    }

    public ImagePreview(MainJFrame mainJFrame, JFileChooser fc, int quality, boolean flag, int option) {
        this.mainJFrame = mainJFrame;
        this.fc = fc;
        this.quality = quality;
        this.flag = flag;
        fc.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout(0, 0));
        this.northJPanel = new JPanel();
        this.northJPanel.setLayout(new BorderLayout(0, 0));
        this.southJPanel = new JPanel();
        this.southJPanel.setLayout(new BorderLayout(0, 0));
        this.jlabel = new JLabel(" JPEG \u306e\u54c1\u8cea");
        this.jtextField = new JTextField(Integer.toString(quality), 3);
        this.jtextField.addActionListener(this);
        this.jslider = new JSlider(0, 100, quality);
        this.jslider.addChangeListener(this);
        this.jslider.setMajorTickSpacing(25);
        this.jslider.setMinorTickSpacing(5);
        this.jslider.setPaintTicks(true);
        this.jslider.setPaintLabels(true);
        this.northJPanel.add((Component)this.jlabel, "West");
        this.northJPanel.add((Component)this.jslider, "South");
        this.northJPanel.add((Component)this.jtextField, "East");
        switch (option) {
            case 0: {
                this.add((Component)this.northJPanel, "North");
                this.setPreferredSize(new Dimension(280, 240));
                this.jcheckBox = new JCheckBox("\u753b\u50cf\u3082 JPEG \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u3078\u4fdd\u5b58\u3059\u308b", flag);
                this.jcheckBox.addActionListener(this);
                this.southJPanel.add((Component)this.jcheckBox, "South");
                break;
            }
            case 1: {
                this.setPreferredSize(new Dimension(204, 256));
                this.jcheckBox = new JCheckBox("\u67a0\u3082\u4e00\u7dd2\u306b\u4fdd\u5b58\u3059\u308b", flag);
                this.jcheckBox.addActionListener(this);
                this.pictureFileFormatJComboBox = new JComboBox<String>(new String[]{"\u25cf \u753b\u50cf\u306e\u4fdd\u5b58\u5f62\u5f0f :: JPEG", "\u25cf \u753b\u50cf\u306e\u4fdd\u5b58\u5f62\u5f0f :: PNG"});
                this.pictureFileFormatJComboBox.addActionListener(this);
                this.southJPanel.add((Component)this.jcheckBox, "North");
                this.southJPanel.add(this.pictureFileFormatJComboBox, "South");
                break;
            }
            case 2: {
                this.setPreferredSize(new Dimension(204, 240));
                this.jcheckBox = new JCheckBox("\u67a0\u3082\u4e00\u7dd2\u306b\u4fdd\u5b58\u3059\u308b", flag);
                this.jcheckBox.addActionListener(this);
                this.southJPanel.add((Component)this.jcheckBox, "South");
            }
        }
        this.add((Component)this.northJPanel, "North");
        this.add((Component)this.southJPanel, "South");
    }

    public ImagePreview(MainJFrame mainJFrame, JFileChooser fc, boolean flag, int option) {
        this.mainJFrame = mainJFrame;
        this.fc = fc;
        this.flag = flag;
        fc.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout(0, 0));
        switch (option) {
            case 0: {
                this.setPreferredSize(new Dimension(280, 240));
                this.jcheckBox = new JCheckBox("\u753b\u50cf\u3082 JPEG \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u8aad\u307f\u8fbc\u3080", flag);
                break;
            }
            case 1: {
                this.setPreferredSize(new Dimension(204, 240));
                this.jcheckBox = new JCheckBox("\u67a0\u3082\u4e00\u7dd2\u306b\u4fdd\u5b58\u3059\u308b", flag);
            }
        }
        this.jcheckBox.addActionListener(this);
        this.add((Component)this.jcheckBox, "South");
    }

    public ImagePreview(MainJFrame mainJFrame, JFileChooser fc, int colorOption, int shapeOption, int option) {
        this.mainJFrame = mainJFrame;
        this.fc = fc;
        this.colorOption = colorOption;
        this.shapeOption = shapeOption;
        fc.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout(0, 0));
        this.colorOptionJComboBox = new JComboBox<String>(new String[]{"\u25cf \u8272 :: \u753b\u50cf\u304b\u3089\u53d6\u5f97", "\u25cf \u8272 :: \u3059\u3079\u3066\u540c\u3058\u8272"});
        this.colorOptionJComboBox.setSelectedIndex(colorOption);
        this.setPreferredSize(new Dimension(204, 240));
        switch (option) {
            case 0: {
                this.shapeOptionJComboBox = new JComboBox<String>(new String[]{"\u25cf \u5f62 :: \u6b63\u65b9\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u6b63\u516d\u9762\u4f53", "\u25cf \u5f62 :: \u56db\u89d2\u67f1", "\u25cf \u5f62 :: \u5186\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u7403", "\u25cf \u5f62 :: \u5186\u67f1", "\u25cf \u5f62 :: \u30e1\u30c3\u30b7\u30e5\uff11"});
                break;
            }
            case 1: {
                this.shapeOptionJComboBox = new JComboBox<String>(new String[]{"\u25cf \u5f62 :: \u6b63\u65b9\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u6b63\u516d\u9762\u4f53", "\u25cf \u5f62 :: \u56db\u89d2\u67f1", "\u25cf \u5f62 :: \u5186\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u7403", "\u25cf \u5f62 :: \u5186\u67f1", "\u25cf \u5f62 :: \u70b9", "\u25cf \u5f62 :: \u9ad8\u3055\u65b9\u5411\u306e\u7dda\uff11", "\u25cf \u5f62 :: \u9ad8\u3055\u65b9\u5411\u306e\u7dda\uff12", "\u25cf \u5f62 :: \u30d5\u30a7\u30fc\u30b9\uff11", "\u25cf \u5f62 :: \u30d5\u30a7\u30fc\u30b9\uff12", "\u25cf \u5f62 :: \u30b0\u30ea\u30c3\u30c9\uff11", "\u25cf \u5f62 :: \u30b0\u30ea\u30c3\u30c9\uff12"});
                break;
            }
            case 2: {
                this.shapeOptionJComboBox = new JComboBox<String>(new String[]{"\u25cf \u5f62 :: \u6b63\u65b9\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u6b63\u516d\u9762\u4f53", "\u25cf \u5f62 :: \u56db\u89d2\u67f1", "\u25cf \u5f62 :: \u5186\u5f62\u306e\u9762", "\u25cf \u5f62 :: \u7403", "\u25cf \u5f62 :: \u5186\u67f1"});
            }
        }
        this.shapeOptionJComboBox.setSelectedIndex(shapeOption);
        this.colorOptionJComboBox.addActionListener(this);
        this.shapeOptionJComboBox.addActionListener(this);
        this.add(this.colorOptionJComboBox, "North");
        this.add(this.shapeOptionJComboBox, "South");
    }

    public ImagePreview(MainJFrame mainJFrame, JFileChooser fc, int width, int height, int scaleWidth, int scaleHeight) {
        this.fc = fc;
        this.mainJFrame = mainJFrame;
        this.SCW = scaleWidth;
        this.SCH = scaleHeight;
        this.W_W = width;
        this.W_H = height;
        fc.addPropertyChangeListener(this);
        this.setPreferredSize(new Dimension(204, 240));
        this.centerX = width / 2;
        this.centerY = height / 2;
        this.saveDataIfsXJSlider = new JSlider(this.dataCols / 2, width - this.dataCols / 2 - 1, width / 2);
        this.saveDataIfsXJSlider.addChangeListener(this);
        this.saveDataIfsXJSlider.setMajorTickSpacing(8);
        this.saveDataIfsXJSlider.setPaintTicks(true);
        this.saveDataIfsYJSlider = new JSlider(this.dataRows / 2, height - this.dataRows / 2 - 1, height / 2);
        this.saveDataIfsYJSlider.addChangeListener(this);
        this.saveDataIfsYJSlider.setOrientation(1);
        this.saveDataIfsYJSlider.setMajorTickSpacing(8);
        this.saveDataIfsYJSlider.setPaintTicks(true);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.saveDataIfsXJSlider, "South");
        this.add((Component)this.saveDataIfsYJSlider, "West");
        this.drawRectOnPictureJPanel();
    }

    protected boolean getFlag() {
        return this.flag;
    }

    protected int getPictureFileFormat() {
        return this.pictureFileFormat;
    }

    protected int getQuality() {
        return this.quality;
    }

    protected int getColorOption() {
        return this.colorOption;
    }

    protected int getShapeOption() {
        return this.shapeOption;
    }

    protected void loadImage() {
        if (this.file == null) {
            return;
        }
        this.tmpIcon = new ImageIcon(this.file.getPath());
        if (Utils.getExtension(this.file).equals("jfd") || Utils.getExtension(this.file).equals("jft")) {
            try {
                int colorAssignmentOption;
                FileInputStream in = new FileInputStream(this.file);
                DataInputStream ds = new DataInputStream(in);
                int version = ds.readInt();
                int programOption = 0;
                programOption = version <= 18 ? version : ds.readInt();
                int programFormula1Option = 0;
                int programFormula4Option = 0;
                if (programOption == 18) {
                    ds.skipBytes(4);
                    programFormula1Option = ds.readInt();
                    ds.skipBytes(4);
                    ds.skipBytes(4);
                    programFormula4Option = ds.readInt();
                    if (programFormula4Option == 3) {
                        ds.skipBytes(4);
                    }
                }
                ds.skipBytes(4);
                ds.skipBytes(4);
                int renderingSizeOption = ds.readInt();
                int W_W = 0;
                int W_H = 0;
                switch (renderingSizeOption) {
                    case 0: {
                        W_W = 320;
                        W_H = 240;
                        break;
                    }
                    case 1: {
                        W_W = 480;
                        W_H = 360;
                        break;
                    }
                    case 2: {
                        W_W = 640;
                        W_H = 480;
                        break;
                    }
                    case 3: {
                        W_W = 800;
                        W_H = 600;
                        break;
                    }
                    case 4: {
                        W_W = 1024;
                        W_H = 768;
                        break;
                    }
                    case 9: {
                        W_W = ds.readInt();
                        W_H = ds.readInt();
                    }
                }
                int rgbOrderOption = ds.readInt();
                if (version <= 7010101 && rgbOrderOption == 7) {
                    rgbOrderOption = 10;
                }
                if (rgbOrderOption == 10) {
                    int colorTableLength = ds.readInt();
                    for (int i = 0; i < colorTableLength; ++i) {
                        ds.skipBytes(4);
                    }
                }
                if ((colorAssignmentOption = ds.readInt()) == 4) {
                    ds.skipBytes(4);
                }
                ds.skipBytes(4);
                if (rgbOrderOption < 6) {
                    ds.skipBytes(4);
                    ds.skipBytes(4);
                    ds.skipBytes(4);
                } else if (rgbOrderOption == 6) {
                    ds.skipBytes(4);
                } else if (rgbOrderOption > 6 && rgbOrderOption < 10) {
                    ds.skipBytes(4);
                    ds.skipBytes(4);
                    ds.skipBytes(4);
                    ds.skipBytes(4);
                    ds.skipBytes(4);
                }
                ds.skipBytes(8);
                ds.skipBytes(8);
                ds.skipBytes(8);
                ds.skipBytes(4);
                ds.skipBytes(8);
                if (programOption == 18 && programFormula4Option > 0) {
                    ds.skipBytes(8);
                }
                if (programOption != 0 && (programOption != 18 || programFormula1Option != 0) || version <= 18) {
                    ds.skipBytes(8);
                    ds.skipBytes(8);
                }
                ds.skipBytes(8);
                if (Utils.getExtension(this.file).equals("jft")) {
                    ds.skipBytes(W_W * W_H * 4);
                }
                if (Utils.getExtension(this.file).equals("jft")) {
                    ds.skipBytes(W_W * W_H * 4);
                }
                BufferedImage img = new BufferedImage(W_W, W_H, 5);
                try {
                    img = ImageIO.read(in);
                }
                catch (IllegalArgumentException iae) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                ds.close();
                in.close();
                this.tmpIcon = new ImageIcon(img);
            }
            catch (Exception e) {}
        } else if (Utils.getExtension(this.file).equals("jfc")) {
            try {
                int col;
                int width;
                FileInputStream in = new FileInputStream(this.file);
                DataInputStream ds = new DataInputStream(in);
                ds.skipBytes(4);
                int colorTableLength = ds.readInt();
                int height = width = 120 / ((int)Math.sqrt(colorTableLength) + 1);
                int row = col = (int)Math.sqrt(colorTableLength) + 1;
                BufferedImage img = new BufferedImage(120, 120, 5);
                Graphics g = img.getGraphics();
                g.setColor(this.fc.getBackground());
                g.fillRect(0, 0, 120, 120);
                for (int i = 0; i < row; ++i) {
                    for (int j = 0; j < col && col * i + j + 1 <= colorTableLength; ++j) {
                        g.setColor(Utils.handleSinglePixel(ds.readInt()));
                        g.fillRect(width * j, height * i, width, height);
                    }
                }
                ds.close();
                in.close();
                this.tmpIcon = new ImageIcon(img);
            }
            catch (Exception e) {}
        } else if (Utils.getExtension(this.file).equals("ifs")) {
            try {
                FileInputStream in = new FileInputStream(this.file);
                DataInputStream ds = new DataInputStream(in);
                ds.skipBytes(4);
                ds.skipBytes(4);
                ds.skipBytes(4);
                ds.skipBytes(4);
                ds.skipBytes(4);
                ds.skipBytes(4);
                ds.skipBytes(4);
                ds.skipBytes(4);
                ds.skipBytes(4);
                ds.skipBytes(4);
                ds.skipBytes(4);
                int colorOrderOption = ds.readInt();
                int colorAssignmentOption = ds.readInt();
                int csp = ds.readInt();
                int cs = ds.readInt();
                int rcq = ds.readInt();
                int gcq = ds.readInt();
                int bcq = ds.readInt();
                ds.skipBytes(4);
                int colorQuantity = rcq * gcq * bcq;
                ColorTable ct = new ColorTable(rcq, gcq, bcq, colorOrderOption);
                ds.skipBytes(8);
                ds.skipBytes(8);
                ds.skipBytes(8);
                int n = ds.readInt();
                ds.skipBytes(8);
                ds.skipBytes(8);
                ds.skipBytes(8);
                ds.skipBytes(8);
                ds.skipBytes(8);
                this.dataCols = ds.readInt();
                this.dataRows = ds.readInt();
                this.pointX = ds.readInt();
                this.pointY = ds.readInt();
                int[][] pixels = new int[this.dataCols][this.dataRows];
                BufferedImage img = new BufferedImage(this.dataCols, this.dataRows, 5);
                Graphics g = img.getGraphics();
                g.setColor(this.fc.getBackground());
                g.fillRect(0, 0, this.dataCols, this.dataRows);
                int cc = 0;
                for (int j = 0; j < this.dataCols; ++j) {
                    for (int k = 0; k < this.dataRows; ++k) {
                        pixels[j][k] = ds.readInt();
                        cc = ct.getColorTableNumber(colorAssignmentOption, csp, cs, colorQuantity, pixels[j][k], n);
                        g.setColor(ct.colorTable[cc]);
                        g.fillRect(j, k, 1, 1);
                    }
                }
                ds.close();
                in.close();
                this.tmpIcon = new ImageIcon(img);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.thumbnail = this.tmpIcon.getIconWidth() > 120 ? new ImageIcon(this.tmpIcon.getImage().getScaledInstance(120, -1, 1)) : this.tmpIcon;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("SelectedFileChangedProperty")) {
            this.file = (File)e.getNewValue();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.loadImage();
        if (this.thumbnail != null) {
            int x = (this.getWidth() - this.thumbnail.getIconWidth()) / 2;
            int y = (this.getHeight() - this.thumbnail.getIconHeight()) / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 8) {
                x = 8;
            }
            this.thumbnail.paintIcon(this, g, x, y);
            if (this.tmpIcon.getIconWidth() != -1 && !Utils.getExtension(this.file).equals("jfc")) {
                Utils.drawText(g, null, "w:" + Integer.toString(this.tmpIcon.getIconWidth()) + ", h:" + Integer.toString(this.tmpIcon.getIconHeight()), x, y + this.thumbnail.getIconHeight() + 16, this.thumbnail.getIconWidth(), 12, this.getBackground(), this.getForeground());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jcheckBox) {
            this.flag = this.jcheckBox.isSelected();
        } else if (e.getSource() == this.pictureFileFormatJComboBox) {
            this.pictureFileFormat = this.pictureFileFormatJComboBox.getSelectedIndex();
            if (this.pictureFileFormat == 0) {
                this.jlabel.setEnabled(true);
                this.jtextField.setEnabled(true);
                this.jslider.setEnabled(true);
            } else if (this.pictureFileFormat == 1) {
                this.jlabel.setEnabled(false);
                this.jtextField.setEnabled(false);
                this.jslider.setEnabled(false);
            }
        } else if (e.getSource() == this.colorOptionJComboBox) {
            this.colorOption = this.colorOptionJComboBox.getSelectedIndex();
        } else if (e.getSource() == this.shapeOptionJComboBox) {
            this.shapeOption = this.shapeOptionJComboBox.getSelectedIndex();
        } else if (e.getSource() == this.jtextField) {
            int quality0 = this.quality;
            try {
                quality0 = Integer.parseInt(this.jtextField.getText());
                if (quality0 >= 0 && quality0 <= 100) {
                    this.quality = quality0;
                    this.jslider.setValue(this.quality);
                } else {
                    this.jtextField.selectAll();
                    this.jtextField.replaceSelection(Integer.toString(this.quality));
                    Utils.showWarningMessage(this, "\u5165\u529b\u3067\u304d\u308b\u306e\u306f 0 \uff5e 100 \u307e\u3067\u306e\u6574\u6570\u3067\u3059\u3002");
                }
            }
            catch (NumberFormatException nfe) {
                this.jtextField.selectAll();
                this.jtextField.replaceSelection(Integer.toString(this.quality));
                Utils.showWarningMessage(this, nfe.getMessage() + "\n\u300c\u6574\u6570\u3067\u306a\u3044\u6570\u5b57\u300d\u304b\u300c\u6587\u5b57\u300d\u3092\u5165\u529b\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f\u3002");
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.jslider) {
            this.quality = this.jslider.getValue();
            this.jtextField.selectAll();
            this.jtextField.replaceSelection(Integer.toString(this.quality));
        } else if (e.getSource() == this.saveDataIfsXJSlider || e.getSource() == this.saveDataIfsYJSlider) {
            if (e.getSource() == this.saveDataIfsXJSlider) {
                this.pointX = this.saveDataIfsXJSlider.getValue() - this.centerX;
            } else if (e.getSource() == this.saveDataIfsYJSlider) {
                this.pointY = this.saveDataIfsYJSlider.getValue() - this.centerY + 1;
            }
            this.drawRectOnPictureJPanel();
        }
    }

    public void drawRectOnPictureJPanel() {
        if (this.isVisible()) {
            this.mainJFrame.g.drawImage(this.mainJFrame.tmpImage, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this);
            this.mainJFrame.offg.drawImage(this.mainJFrame.tmpImage, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this.SCW, this.SCH, this.SCW + this.W_W, this.SCH + this.W_H, this);
            Utils.drawDrawRect(this.mainJFrame.g, this.mainJFrame.offg, this.SCW + this.centerX + this.pointX - this.dataCols / 2, this.SCH + this.centerY - this.pointY - this.dataRows / 2, this.dataCols, this.dataRows, Utils.A1C);
            Utils.drawDrawRect(this.mainJFrame.g, this.mainJFrame.offg, this.SCW + this.centerX + this.pointX - this.dataCols / 2 + 1, this.SCH + this.centerY - this.pointY - this.dataRows / 2 + 1, this.dataCols - 2, this.dataRows - 2, Utils.A2C);
        }
    }
}

