/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Date;

public class Data {
    protected int W_W;
    protected int W_H;
    protected int SCW;
    protected int SCH;
    protected int F_W;
    protected int F_H;
    protected int[][] pixels;
    protected String subTitleString;
    Color[] color;
    protected int csp;
    protected int cs;
    protected int rcq;
    protected int gcq;
    protected int bcq;
    protected int rgbcq;
    protected int acq;
    protected int ctq;
    protected int hsbcq;
    protected int hsbcqMax;
    protected float hsb_low;
    protected float hsb_high;
    protected float hsb_1;
    protected float hsb_2;
    protected double mf;
    protected int n;
    protected double s;
    protected double ss;
    protected double wx0;
    protected double wy0;
    protected double a;
    protected double b;
    protected BufferedImage tmpImage;
    protected int programOption;
    protected int programFormula0Option;
    protected int programFormula1Option;
    protected int programFormula2Option;
    protected int programFormula3Option;
    protected int programFormula4Option;
    protected int programFormula5Option;
    protected int renderingQualityOption;
    protected int renderingSpeedOption;
    protected int renderingSizeOption;
    protected int windowWidth;
    protected int windowHeight;
    protected int colorAssignmentOption;
    protected int colorOrderOption;
    protected int i = 1;
    protected boolean calculationFlag;
    protected Date dateNow;
    protected MainJFrame mainJFrame;

    public Data() {
    }

    public Data(MainJFrame mainJFrame) {
        this.mainJFrame = mainJFrame;
        this.rgbcq = mainJFrame.rgbcq;
    }

    protected void setData() {
        int j;
        this.W_W = this.mainJFrame.W_W;
        this.W_H = this.mainJFrame.W_H;
        this.SCW = this.mainJFrame.SCW;
        this.SCH = this.mainJFrame.SCH;
        this.F_W = this.SCW + this.W_W + this.SCW;
        this.F_H = this.SCH + this.W_H + this.SCH;
        this.subTitleString = Utils.subTitleString;
        this.tmpImage = this.mainJFrame.tmpImage;
        this.renderingQualityOption = this.mainJFrame.renderingQualityOption;
        this.renderingSpeedOption = this.mainJFrame.renderingSpeedOption;
        this.renderingSizeOption = this.mainJFrame.renderingSizeOption;
        this.windowWidth = this.mainJFrame.windowWidth;
        this.windowHeight = this.mainJFrame.windowHeight;
        if (this.renderingQualityOption == 0) {
            this.i = 1;
        } else if (this.renderingQualityOption == 1 || this.renderingQualityOption == 2) {
            this.i = 2;
        } else if (this.renderingQualityOption == 3 || this.renderingQualityOption == 4) {
            this.i = 4;
        }
        if (this.mainJFrame.pixels != null) {
            this.pixels = new int[this.W_W / this.i][this.W_H / this.i];
            for (j = 0; j < this.W_W / this.i; ++j) {
                for (int k = 0; k < this.W_H / this.i; ++k) {
                    this.pixels[j][k] = this.mainJFrame.pixels[j][k];
                }
            }
        }
        this.programOption = this.mainJFrame.programOption;
        this.programFormula0Option = this.mainJFrame.programFormula0Option;
        this.programFormula1Option = this.mainJFrame.programFormula1Option;
        this.programFormula2Option = this.mainJFrame.programFormula2Option;
        this.programFormula3Option = this.mainJFrame.programFormula3Option;
        this.programFormula4Option = this.mainJFrame.programFormula4Option;
        this.programFormula5Option = this.mainJFrame.programFormula5Option;
        this.color = new Color[this.mainJFrame.ct.colorTable.length];
        for (j = 0; j < this.mainJFrame.ct.colorTable.length; ++j) {
            this.color[j] = this.mainJFrame.ct.colorTable[j];
        }
        this.colorOrderOption = this.mainJFrame.colorOrderOption;
        this.colorAssignmentOption = this.mainJFrame.colorAssignmentOption;
        this.csp = this.mainJFrame.csp;
        this.cs = this.mainJFrame.cs;
        this.rcq = this.mainJFrame.rcq;
        this.gcq = this.mainJFrame.gcq;
        this.bcq = this.mainJFrame.bcq;
        this.acq = this.mainJFrame.acq;
        this.ctq = this.mainJFrame.ctq;
        this.hsbcq = this.mainJFrame.hsbcq;
        this.hsbcqMax = this.mainJFrame.hsbcqMax;
        this.hsb_low = this.mainJFrame.hsb_low;
        this.hsb_high = this.mainJFrame.hsb_high;
        this.hsb_1 = this.mainJFrame.hsb_1;
        this.hsb_2 = this.mainJFrame.hsb_2;
        this.mf = this.mainJFrame.mf;
        this.wx0 = this.mainJFrame.wx0;
        this.wy0 = this.mainJFrame.wy0;
        this.n = this.mainJFrame.n;
        this.s = this.mainJFrame.s;
        this.ss = this.mainJFrame.ss;
        this.a = this.mainJFrame.a;
        this.b = this.mainJFrame.b;
        this.calculationFlag = this.mainJFrame.calculationFlag;
        this.dateNow = new Date(this.mainJFrame.dateNow.getTime());
    }

    protected void getData() {
        int j;
        this.mainJFrame.W_W = this.W_W;
        this.mainJFrame.W_H = this.W_H;
        this.mainJFrame.SCW = this.SCW;
        this.mainJFrame.SCH = this.SCH;
        this.mainJFrame.F_W = this.F_W;
        this.mainJFrame.F_H = this.F_H;
        Utils.subTitleString = this.subTitleString;
        this.mainJFrame.tmpImage = this.tmpImage;
        this.mainJFrame.renderingQualityOption = this.renderingQualityOption;
        this.mainJFrame.renderingSpeedOption = this.renderingSpeedOption;
        this.mainJFrame.renderingSizeOption = this.renderingSizeOption;
        this.mainJFrame.windowWidth = this.windowWidth;
        this.mainJFrame.windowHeight = this.windowHeight;
        if (this.pixels != null) {
            this.mainJFrame.pixels = new int[this.W_W / this.i][this.W_H / this.i];
            for (j = 0; j < this.W_W / this.i; ++j) {
                for (int k = 0; k < this.W_H / this.i; ++k) {
                    this.mainJFrame.pixels[j][k] = this.pixels[j][k];
                }
            }
        }
        this.mainJFrame.programOption = this.programOption;
        this.mainJFrame.programFormula0Option = this.programFormula0Option;
        this.mainJFrame.programFormula1Option = this.programFormula1Option;
        this.mainJFrame.programFormula2Option = this.programFormula2Option;
        this.mainJFrame.programFormula3Option = this.programFormula3Option;
        this.mainJFrame.programFormula4Option = this.programFormula4Option;
        this.mainJFrame.programFormula5Option = this.programFormula5Option;
        this.mainJFrame.ct.colorTable = new Color[this.color.length];
        for (j = 0; j < this.color.length; ++j) {
            this.mainJFrame.ct.colorTable[j] = this.color[j];
        }
        this.mainJFrame.colorOrderOption = this.colorOrderOption;
        this.mainJFrame.colorAssignmentOption = this.colorAssignmentOption;
        this.mainJFrame.csp = this.csp;
        this.mainJFrame.cs = this.cs;
        this.mainJFrame.rcq = this.rcq;
        this.mainJFrame.gcq = this.gcq;
        this.mainJFrame.bcq = this.bcq;
        this.mainJFrame.acq = this.acq;
        this.mainJFrame.ctq = this.ctq;
        this.mainJFrame.hsbcq = this.hsbcq;
        this.mainJFrame.hsbcqMax = this.hsbcqMax;
        this.mainJFrame.hsb_low = this.hsb_low;
        this.mainJFrame.hsb_high = this.hsb_high;
        this.mainJFrame.hsb_1 = this.hsb_1;
        this.mainJFrame.hsb_2 = this.hsb_2;
        this.mainJFrame.mf = this.mf;
        this.mainJFrame.wx0 = this.wx0;
        this.mainJFrame.wy0 = this.wy0;
        this.mainJFrame.n = this.n;
        this.mainJFrame.s = this.s;
        this.mainJFrame.ss = this.ss;
        this.mainJFrame.a = this.a;
        this.mainJFrame.b = this.b;
        this.mainJFrame.calculationFlag = this.calculationFlag;
        this.mainJFrame.dateNow = new Date(this.dateNow.getTime());
    }

    protected boolean checkData() {
        boolean flag = true;
        if (this.renderingQualityOption < 0 || this.renderingQualityOption > 4) {
            flag = false;
        } else if (this.renderingSpeedOption < 0 || this.renderingSpeedOption > 1) {
            flag = false;
        } else if (this.renderingSizeOption < 0 || this.renderingSizeOption > 4 && this.renderingSizeOption != 9) {
            flag = false;
        } else if (this.colorOrderOption < 0 || this.colorOrderOption > 10) {
            flag = false;
        } else if (this.colorAssignmentOption < 0 || this.colorAssignmentOption > 4) {
            flag = false;
        } else if (this.rcq < 1 || this.rcq > 256) {
            flag = false;
        } else if (this.gcq < 1 || this.gcq > 256) {
            flag = false;
        } else if (this.bcq < 1 || this.bcq > 256) {
            flag = false;
        } else if (this.rcq * this.gcq * this.bcq > this.rgbcq) {
            flag = false;
        } else if (this.acq < 1 || this.acq > 256) {
            flag = false;
        } else if (this.ctq < 1 || this.ctq > this.rgbcq) {
            flag = false;
        } else if (this.csp > -2 && this.csp < 2) {
            flag = false;
        } else if (this.cs < -this.rcq * this.gcq * this.bcq || this.cs > this.rcq * this.gcq * this.bcq) {
            flag = false;
        } else if (this.hsbcq < 1 || this.hsbcq > this.hsbcqMax) {
            flag = false;
        } else if (this.hsb_low < 0.0f || this.hsb_low > 1.0f) {
            flag = false;
        } else if (this.hsb_high < 0.0f || this.hsb_high > 1.0f) {
            flag = false;
        } else if (this.hsb_1 < 0.0f || this.hsb_1 > 1.0f) {
            flag = false;
        } else if (this.hsb_2 < 0.0f || this.hsb_2 > 1.0f) {
            flag = false;
        } else if (this.programOption < 0 || this.programOption > 18) {
            flag = false;
        } else if (this.programFormula0Option < 0 || this.programFormula0Option % 10000 > Utils.programFormula0String.length) {
            flag = false;
        } else if (this.programFormula0Option / 10000 != 0 && this.programFormula0Option / 10000 != 1) {
            flag = false;
        } else if (this.programFormula1Option < 0 || this.programFormula1Option > Utils.programFormula1String.length) {
            flag = false;
        } else if (this.programFormula2Option < 0 || this.programFormula2Option % 10000 > Utils.programFormula2String.length) {
            flag = false;
        } else if (this.programFormula2Option / 10000 != 0 && this.programFormula2Option / 10000 != 1) {
            flag = false;
        } else if (this.programFormula3Option < 0 || this.programFormula3Option > Utils.programFormula3String.length) {
            flag = false;
        } else if (this.programFormula4Option < 0 || this.programFormula4Option > Utils.programFormula4String.length) {
            flag = false;
        } else if (this.programFormula5Option < 0 || this.programFormula5Option > Utils.programFormula5String.length) {
            flag = false;
        } else if (this.mf <= 0.0) {
            flag = false;
        } else if (this.n < 1) {
            flag = false;
        }
        return flag;
    }
}

