/*
 * Decompiled with CFR 0.152.
 */
public class Complex {
    private double Re;
    private double Im;

    public Complex() {
    }

    public Complex(int ix, int iy) {
        this.Re = ix;
        this.Im = iy;
    }

    public Complex(double x, double y) {
        this.Re = x;
        this.Im = y;
    }

    public Complex(Complex z) {
        this.Re = z.Re;
        this.Im = z.Im;
    }

    public void set(double x, double y) {
        this.Re = x;
        this.Im = y;
    }

    public double getRe() {
        return this.Re;
    }

    public double getIm() {
        return this.Im;
    }

    public void setRe(double x) {
        this.Re = x;
    }

    public void setIm(double y) {
        this.Im = y;
    }

    public String toString() {
        return String.valueOf(this.Re) + " + i " + String.valueOf(this.Im);
    }

    public static Complex conj(Complex z) {
        return new Complex(z.Re, -z.Im);
    }

    public static Complex cadd(Complex z, Complex w) {
        return new Complex(z.Re + w.Re, z.Im + w.Im);
    }

    public static Complex csub(Complex z, Complex w) {
        return new Complex(z.Re - w.Re, z.Im - w.Im);
    }

    public static Complex cmultiR(double r, Complex z) {
        return new Complex(r * z.Re, r * z.Im);
    }

    public static double cabs2(Complex z) {
        return z.Re * z.Re + z.Im * z.Im;
    }

    public static double cabs(Complex z) {
        return Math.sqrt(Complex.cabs2(z));
    }

    public static Complex cmulti(Complex z, Complex w) {
        return new Complex(z.Re * w.Re - z.Im * w.Im, z.Im * w.Re + z.Re * w.Im);
    }

    public static Complex cdiv(Complex z, Complex w) {
        double denom = Complex.cabs2(w);
        return new Complex((z.Re * w.Re + z.Im * w.Im) / denom, (z.Im * w.Re - z.Re * w.Im) / denom);
    }

    public static Complex cexp(Complex z) {
        double r = Math.exp(z.Re);
        return new Complex(r * Math.cos(z.Im), r * Math.sin(z.Im));
    }

    public static Complex clog(Complex z) {
        double r2 = Complex.cabs2(z);
        double r1 = z.Re == 0.0 ? (z.Im > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.atan(z.Im / z.Re);
        if (z.Re < 0.0) {
            r1 = z.Im < 0.0 ? (r1 -= Math.PI) : (r1 += Math.PI);
        }
        return new Complex(Math.log(r2) / 2.0, r1);
    }

    public static Complex croot(Complex z, int n) {
        Complex w = new Complex();
        w = Complex.clog(z);
        w.setRe(w.Re / (double)n);
        w.setIm(w.Im / (double)n);
        return Complex.cexp(w);
    }

    public static Complex csqrt(Complex z) {
        return Complex.croot(z, 2);
    }

    public static Complex cpowerR(Complex z, double r) {
        Complex w = new Complex();
        w = Complex.clog(z);
        w.setRe(w.Re * r);
        w.setIm(w.Im * r);
        w = Complex.cexp(w);
        return w;
    }

    public static Complex cpower(Complex a, Complex b) {
        Complex x = new Complex();
        Complex y = new Complex();
        x = Complex.clog(a);
        y = Complex.cmulti(b, x);
        return Complex.cexp(y);
    }

    public static Complex csin(Complex a) {
        double sh = (Math.exp(a.Im) - 1.0 / Math.exp(a.Im)) / 2.0;
        double ch = (Math.exp(a.Im) + 1.0 / Math.exp(a.Im)) / 2.0;
        return new Complex(Math.sin(a.Re) * ch, Math.cos(a.Re) * sh);
    }

    public static Complex ccos(Complex a) {
        double sh = (Math.exp(a.Im) - 1.0 / Math.exp(a.Im)) / 2.0;
        double ch = (Math.exp(a.Im) + 1.0 / Math.exp(a.Im)) / 2.0;
        return new Complex(Math.cos(a.Re) * ch, -Math.sin(a.Re) * sh);
    }

    public static Complex ctan(Complex a) {
        return Complex.cdiv(Complex.csin(a), Complex.ccos(a));
    }

    public static Complex ccosec(Complex a) {
        Complex x = new Complex(1, 0);
        return Complex.cdiv(x, Complex.csin(a));
    }

    public static Complex csec(Complex a) {
        Complex x = new Complex(1, 0);
        return Complex.cdiv(x, Complex.ccos(a));
    }

    public static Complex ccot(Complex a) {
        return Complex.cdiv(Complex.ccos(a), Complex.csin(a));
    }
}

