/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JToolBar;

public class ColorTableJToolBar
extends JToolBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton[] jbutton;
    private MainJFrame mainJFrame;

    public ColorTableJToolBar(MainJFrame mainJFrame) {
        this.mainJFrame = mainJFrame;
        this.createColorTableJToolBar();
    }

    public void createColorTableJToolBar() {
        this.setAutoscrolls(true);
        this.setName("JFractal - \u30ab\u30e9\u30fc\u30c6\u30fc\u30d6\u30eb");
    }

    public void createColorTable(ColorTable ct, int colorShift) {
        int i;
        this.removeAll();
        this.setLayout(new GridLayout(ct.colorTable.length / 100 + 1, 100, 0, 0));
        this.jbutton = new JButton[ct.colorTable.length];
        for (i = 0; i < ct.colorTable.length; ++i) {
            this.jbutton[i] = new JButton();
            this.jbutton[i].setBackground(ct.colorTable[i]);
            this.jbutton[i].addActionListener(this);
        }
        if (colorShift >= 0) {
            for (i = colorShift; i < ct.colorTable.length; ++i) {
                this.add(this.jbutton[i]);
            }
            for (i = 0; i < colorShift; ++i) {
                this.add(this.jbutton[i]);
            }
        } else {
            for (i = ct.colorTable.length + colorShift; i < ct.colorTable.length; ++i) {
                this.add(this.jbutton[i]);
            }
            for (i = 0; i < ct.colorTable.length + colorShift; ++i) {
                this.add(this.jbutton[i]);
            }
        }
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mainJFrame.colorOrderOption == 10 && this.mainJFrame.mainThreadOption != 1) {
            for (int i = 0; i < this.mainJFrame.ct.colorTable.length; ++i) {
                Color color;
                if (e.getSource() != this.jbutton[i] || (color = JColorChooser.showDialog(this, "JFractal - \u30ab\u30e9\u30fc\u30c1\u30e5\u30fc\u30b6\u30fc", this.mainJFrame.ct.colorTable[i])) == null) continue;
                this.mainJFrame.undoDataPush();
                this.mainJFrame.ct.colorTable[i] = color;
                this.jbutton[i].setBackground(color);
            }
        } else {
            for (int i = 0; i < this.mainJFrame.ct.colorTable.length; ++i) {
                if (e.getSource() != this.jbutton[i]) continue;
                Color color = this.jbutton[i].getBackground();
                int red = color.getRed();
                int green = color.getGreen();
                int blue = color.getBlue();
                Utils.showInformationMessage(this, "RGB\u306f\u300c\u8d64\uff1a" + red + " , \u7dd1\uff1a" + green + " , \u9752\uff1a" + blue + "\u300d\u3067\u3059\u3002");
            }
        }
    }
}

