/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class ColorTable {
    static int HUE = 0;
    static int SATURATION = 1;
    static int BRIGHTNESS = 2;
    Color[] colorTable;
    int colorNumber;

    public ColorTable(int rcq, int gcq, int bcq, int rgbOrderOption) {
        block19: {
            float blue;
            float green;
            float red;
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block18: {
                                this.colorNumber = 0;
                                red = 1.0f / (float)(rcq - 1);
                                green = 1.0f / (float)(gcq - 1);
                                blue = 1.0f / (float)(bcq - 1);
                                this.colorTable = new Color[rcq * gcq * bcq];
                                if (rgbOrderOption != 0) break block18;
                                for (int count_blue = 0; count_blue < bcq; ++count_blue) {
                                    for (int count_green = 0; count_green < gcq; ++count_green) {
                                        for (int count_red = 0; count_red < rcq; ++count_red) {
                                            this.colorTable[this.colorNumber] = new Color(red * (float)count_red, green * (float)count_green, blue * (float)count_blue);
                                            ++this.colorNumber;
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (rgbOrderOption != 1) break block20;
                            for (int count_green = 0; count_green < gcq; ++count_green) {
                                for (int count_blue = 0; count_blue < bcq; ++count_blue) {
                                    for (int count_red = 0; count_red < rcq; ++count_red) {
                                        this.colorTable[this.colorNumber] = new Color(red * (float)count_red, green * (float)count_green, blue * (float)count_blue);
                                        ++this.colorNumber;
                                    }
                                }
                            }
                            break block19;
                        }
                        if (rgbOrderOption != 2) break block21;
                        for (int count_red = 0; count_red < rcq; ++count_red) {
                            for (int count_blue = 0; count_blue < bcq; ++count_blue) {
                                for (int count_green = 0; count_green < gcq; ++count_green) {
                                    this.colorTable[this.colorNumber] = new Color(red * (float)count_red, green * (float)count_green, blue * (float)count_blue);
                                    ++this.colorNumber;
                                }
                            }
                        }
                        break block19;
                    }
                    if (rgbOrderOption != 3) break block22;
                    for (int count_blue = 0; count_blue < bcq; ++count_blue) {
                        for (int count_red = 0; count_red < rcq; ++count_red) {
                            for (int count_green = 0; count_green < gcq; ++count_green) {
                                this.colorTable[this.colorNumber] = new Color(red * (float)count_red, green * (float)count_green, blue * (float)count_blue);
                                ++this.colorNumber;
                            }
                        }
                    }
                    break block19;
                }
                if (rgbOrderOption != 4) break block23;
                for (int count_green = 0; count_green < gcq; ++count_green) {
                    for (int count_red = 0; count_red < rcq; ++count_red) {
                        for (int count_blue = 0; count_blue < bcq; ++count_blue) {
                            this.colorTable[this.colorNumber] = new Color(red * (float)count_red, green * (float)count_green, blue * (float)count_blue);
                            ++this.colorNumber;
                        }
                    }
                }
                break block19;
            }
            if (rgbOrderOption != 5) break block19;
            for (int count_red = 0; count_red < rcq; ++count_red) {
                for (int count_green = 0; count_green < gcq; ++count_green) {
                    for (int count_blue = 0; count_blue < bcq; ++count_blue) {
                        this.colorTable[this.colorNumber] = new Color(red * (float)count_red, green * (float)count_green, blue * (float)count_blue);
                        ++this.colorNumber;
                    }
                }
            }
        }
    }

    public ColorTable(int acq) {
        this.colorNumber = 0;
        float gray = 1.0f / (float)(acq - 1);
        this.colorTable = new Color[acq];
        for (int count = 0; count < acq; ++count) {
            this.colorTable[this.colorNumber] = new Color(gray * (float)count, gray * (float)count, gray * (float)count);
            ++this.colorNumber;
        }
    }

    public ColorTable(int hsbcq, float saturation, float brightness) {
        this.colorNumber = 0;
        float hue = 1.0f / (float)hsbcq;
        this.colorTable = new Color[hsbcq];
        for (int count = 0; count < hsbcq; ++count) {
            this.colorTable[this.colorNumber] = new Color(Color.HSBtoRGB(hue * (float)count, saturation, brightness));
            ++this.colorNumber;
        }
    }

    public ColorTable(int hsbcq, float hue_low, float hue_high, float saturation, float brightness) {
        this.colorNumber = 0;
        float hue = (hue_high - hue_low) / (float)hsbcq;
        if (hue_high < hue_low) {
            hue = (hue_high + (1.0f - hue_low)) / (float)hsbcq;
        }
        this.colorTable = new Color[hsbcq];
        for (int count = 0; count < hsbcq; ++count) {
            this.colorTable[this.colorNumber] = new Color(Color.HSBtoRGB(hue_low + hue * (float)count, saturation, brightness));
            ++this.colorNumber;
        }
    }

    public ColorTable(int hsbcq, float hsb_low, float hsb_high, float hsb_1, float hsb_2, int mode) {
        block9: {
            float plus;
            block10: {
                block8: {
                    this.colorNumber = 0;
                    plus = 0.0f;
                    if (mode == HUE) {
                        if (hsb_high >= hsb_low) {
                            plus = (hsb_high - hsb_low) / (float)hsbcq;
                        } else if (hsb_high < hsb_low) {
                            plus = (1.0f + hsb_high - hsb_low) / (float)hsbcq;
                        }
                    }
                    if (mode == SATURATION || mode == BRIGHTNESS) {
                        plus = Math.abs(hsb_high - hsb_low) / (float)(hsbcq - 1);
                    }
                    this.colorTable = new Color[hsbcq];
                    if (mode != HUE) break block8;
                    for (int count = 0; count < hsbcq; ++count) {
                        this.colorTable[this.colorNumber] = new Color(Color.HSBtoRGB(hsb_low + plus * (float)count, hsb_1, hsb_2));
                        ++this.colorNumber;
                    }
                    break block9;
                }
                if (mode != SATURATION) break block10;
                for (int count = 0; count < hsbcq; ++count) {
                    this.colorTable[this.colorNumber] = new Color(Color.HSBtoRGB(hsb_1, Math.min(hsb_low, hsb_high) + plus * (float)count, hsb_2));
                    ++this.colorNumber;
                }
                break block9;
            }
            if (mode != BRIGHTNESS) break block9;
            for (int count = 0; count < hsbcq; ++count) {
                this.colorTable[this.colorNumber] = new Color(Color.HSBtoRGB(hsb_1, hsb_2, Math.min(hsb_low, hsb_high) + plus * (float)count));
                ++this.colorNumber;
            }
        }
    }

    protected int getColorTableNumber(int colorAssignmentOption, int csp, int cs, int colorQuantity, int value, int valueMax) {
        int colorTableNumber = 0;
        if (colorAssignmentOption == 0) {
            colorTableNumber = value % colorQuantity;
        } else if (colorAssignmentOption == 1) {
            colorTableNumber = colorQuantity - 1 - value % colorQuantity;
        } else if (colorAssignmentOption == 2) {
            colorTableNumber = (int)((long)colorQuantity * (long)value / (long)valueMax);
        } else if (colorAssignmentOption == 3) {
            colorTableNumber = colorQuantity - 1 - (int)((long)colorQuantity * (long)value / (long)valueMax);
        } else if (colorAssignmentOption == 4) {
            colorTableNumber = csp > 0 ? value / csp % colorQuantity : colorQuantity - 1 + value / csp % colorQuantity;
        }
        colorTableNumber = (colorTableNumber + cs) % colorQuantity;
        if (colorTableNumber < 0) {
            colorTableNumber += colorQuantity;
        }
        return colorTableNumber;
    }
}

